/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2015 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

/**
 * <p>Defines the basic API for creating and managing Content Fragments.</p>
 *
 * <p>Main purpose of this API is to abstract the corresponding content structure and
 * provide convenience methods to manage a fragment.</p>
 *
 * <h3>Elements</h3>
 *
 * <ul>
 *   <li>A content fragment is represented by an instance of
 *     {@link com.adobe.cq.dam.cfm.ContentFragment}.</li>
 *   <li>Each fragment contains content elements. Elements carry semantically
 *     distinctive parts of the fragment (e.g. the title and content elements of a
 *     typical news article).</li>
 *   <li>Each element can have multiple variations of its content. This can be used for
 *     creating longer or shorter versions of the text, depending on the context. For
 *     example, a shorter version may be provided for creating a Twitter-optimized version
 *     of the content.</li>
 * </ul>
 *
 * <p>Each content fragment must have at least one element, but can finally consist of
 * multiple elements. Variations are completely optional.</p>
 *
 * <p>Content (= text fragments) is managed both on the element and the variation level.
 * This means: To access an element's text, first retrieve the element, then use the
 * respective methods to access the text and its MIME type (note that the
 * {@link com.adobe.cq.dam.cfm.converter} API provides means to get a standardized HTML
 * representation of the fragment).</p>
 *
 * <h3>Basic usage</h3>
 *
 * <p>To create a {@link com.adobe.cq.dam.cfm.ContentFragment} from a Sling resource, simply
 * adapt the resource to {@link com.adobe.cq.dam.cfm.ContentFragment}.</p>
 *
 * <p>After adapting the resource, you can access and manipulate the fragment using the
 * respective methods of the API.</p>
 *
 * <p>Note that the API doesn't assume auto-commit. This means that you have to
 * commit the {@code org.apache.sling.api.resource.ResourceResolver} explicitly after
 * manipulating the fragment.</p>
 *
 * <h3>Concurrency</h3>
 *
 * <p>The API is not explicitly designed for sharing its objects between multiple thread,
 * so the user has to take care of correct synchronization should the use case require
 * shared access.</p>
 *
 * <h3>References</h3>
 *
 * <p>The {@link com.adobe.cq.dam.cfm.converter} API provides means to create an HTML
 * representation for content that leverages other formats like plain text or Markdown.
 * It is also used to convert formats back and forth.</p>
 *
 * <p>The {@link com.adobe.cq.dam.cfm.content} API is leveraged for post-processing the
 * content of a fragment instance, before it eventually gets rendered within a specific
 * context. "Fragment instance" in this case means a single occurrence of the fragment in
 * a page (for example).</p>
 *
 * <h3>Structured fragments</h3>
 *
 * <p><i>Version 1.1</i> of the API introduces typed data, extending the purely text-based
 * fragments of version 1.0. Fragments based on typed data are called "structured
 * fragments".</p>
 *
 * <p>The content structure of both fragment types are different. On the API level, they
 * are handled interchangeably: You don't need to explicitly care if you stay within the
 * borders of the system, i.e. stick to the data types that a fragment exposes. To further
 * lower the barrier, the class that is used for wrapping data provides some type
 * conversation rules that allow to access text-based fragments in a typed way.</p>
 *
 * <p>The changes in the API are mainly related to adding support for typed data to elements
 * and variations. Also, some help with converting data (mainly required for text-based
 * fragments) is provided.</p>
 */
@Version("1.11.0")
package com.adobe.cq.dam.cfm;

import org.osgi.annotation.versioning.Version;