/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.dam.index.builder;

import com.adobe.cq.dam.index.builder.api.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import java.util.HashMap;
import java.util.Map;

/**
 * Implements PropertyDefinition of Oak Lucene Property Index
 */
@Deprecated
public class SimplePropertyDefinition implements PropertyDefinition {

    String nodeName;
    String property;
    String propertyType;
    boolean propertyIndex;
    float boost = 1.0f;
    boolean nodeScopeIndex;
    boolean analyzed;
    boolean useInSuggest;
    boolean useInSpellcheck;
    boolean isRegexp;
    boolean index;

    /**
     * Creates a simple PropertyDefinition for oak lucene index
     * @param property property to index
     * @param nodeName PropertyDefinition node name
     */
    public SimplePropertyDefinition(String property, String nodeName) {
        setNodeName(nodeName);
        setProperty(property);
        setPropertyIndex(true);
    }

    /**
     * @param property property to index
     * @param nodeName property definition node name
     * @param boost    index time field boost factor
     */
    public SimplePropertyDefinition(String property, String nodeName, float boost) {
        this(property, nodeName);
        setBoost(boost);
    }

    /**
     * @param property property to index
     * @param nodeName property definition node name
     * @param propertyType propertyType
     */
    public SimplePropertyDefinition(String property, String nodeName, String propertyType) {
        this(property, nodeName);
        setPropertyType(propertyType);
    }

    public SimplePropertyDefinition(String property, String nodeName, float boost, boolean analyzed) {
        this(property, nodeName, boost);
        setAnalyzed(analyzed);
    }

    public SimplePropertyDefinition(String property, String nodeName, float boost, boolean analyzed, boolean useInSuggest) {
        this(property, nodeName, boost);
        setAnalyzed(analyzed);
        setUseInSuggest(useInSuggest);
    }

    public SimplePropertyDefinition(String property, String nodeName, float boost, boolean analyzed, boolean useInSuggest, boolean useInSpellcheck) {
        this(property, nodeName, boost);
        setAnalyzed(analyzed);
        setUseInSuggest(useInSuggest);
        setUseInSpellcheck(useInSpellcheck);
    }

    public SimplePropertyDefinition(String property, String nodeName, boolean index, boolean propertyIndex, boolean isRegexp) {
        setNodeName(nodeName);
        setProperty(property);
        setIndex(index);
        setRegexp(isRegexp);
        setPropertyIndex(propertyIndex);
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setProperty(String prop) {
        this.property = prop;
    }

    public void setPropertyType(String type) {
        this.propertyType = type;
    }

    private void setPropertyIndex(boolean propertyIndex) {
        this.propertyIndex = propertyIndex;
    }

    private void setIndex(boolean index) {
        this.index = index;
    }

    private void setRegexp(boolean isRegexp) {
        this.isRegexp = isRegexp;
    }

    public void setBoost(float boost) {
        this.boost = boost;
        this.nodeScopeIndex = true;
    }

    public void setAnalyzed(boolean analyzed) {
        this.analyzed = analyzed;
    }

    public void setUseInSuggest(boolean useInSuggest) {
        this.useInSuggest = useInSuggest;
    }

    public void setUseInSpellcheck(boolean useInSpellcheck) {
        this.useInSpellcheck = useInSpellcheck;
    }

    /**
     * {@inheritDoc}
     */
    public void build(Resource resource) throws PersistenceException {
        ResourceResolver resolver = resource.getResourceResolver();
        // if PropertyDefinition exists, recreate
        if (resolver.getResource(resource, nodeName) != null) {
            resolver.delete(resolver.getResource(resource, nodeName));
        }
        Map<String, Object> propsMap = new HashMap<String, Object>();
        propsMap.put(LuceneIndexConstants.PROP_NAME, property);
        propsMap.put(LuceneIndexConstants.PROP_PROPERTY_INDEX, propertyIndex);
        if (analyzed) {
            propsMap.put(LuceneIndexConstants.PROP_ANALYZED, true);
        }
        if(useInSuggest) {
            propsMap.put(LuceneIndexConstants.PROP_USE_IN_SUGGEST, true);
            propsMap.put(LuceneIndexConstants.PROP_NODE_SCOPE_INDEX, true);
        }
        if(useInSpellcheck) {
            propsMap.put(LuceneIndexConstants.PROP_USE_IN_SPELLCHECK, true);
            propsMap.put(LuceneIndexConstants.PROP_NODE_SCOPE_INDEX, true);
        }
        if (boost != 1.0f) {
            propsMap.put(LuceneIndexConstants.FIELD_BOOST, boost);
            propsMap.put(LuceneIndexConstants.PROP_NODE_SCOPE_INDEX, nodeScopeIndex);
        }
        if (propertyType != null && !propertyType.isEmpty()) {
            propsMap.put(LuceneIndexConstants.PROP_TYPE, propertyType);
        }
        if(index) {
            propsMap.put(LuceneIndexConstants.PROP_INDEX, index);
        }
        if(isRegexp) {
            propsMap.put(LuceneIndexConstants.PROP_IS_REGEX, isRegexp);
        }
        resolver.create(resource, nodeName, propsMap);
    }
}
