/*************************************************************************
* ADOBE CONFIDENTIAL
* __________________
*
* Copyright 2011 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.jmx.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Provides information needed to generate
 * {@link javax.management.openmbean.TabularType}. The class that is
 * representing {@link javax.management.openmbean.TabularData} must be annotated
 * by this annotation.
 */
@Target({ ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface TabularTypeInfo {
    /**
     * See {@link javax.management.openmbean.TabularType#getRowType()}.
     * @return the type of each row
     */
    Class<?> rowType();

    /**
     * See {@link javax.management.openmbean.TabularType#getIndexNames()}.
     * @return a List of String representing the names of the index items.
     */
    String[] indexNames();
}
