/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.rest;

/**
 * The RestException is the base exception used throughout the API. This
 * exception should only be thrown if there is no more specific exception
 * defined in the API for the cause otherwise a more specific exception must be
 * used.
 * <p>
 * The RestException is a RuntimeException because it is not intended to be
 * caught by client code.
 * </p>
 */
@SuppressWarnings("serial")
public class RestException extends RuntimeException {

    /**
     * Creates a RestException
     * 
     * @param message the detail message
     */
    public RestException(String message) {
        super(message);
    }

    /**
     * Creates a RestException
     * 
     * @param cause the cause
     */
    public RestException(Throwable cause) {
        super(cause);
    }

    /**
     * Creates a RestException
     * 
     * @param message the detail message
     * @param cause the cause
     */
    public RestException(String message, Throwable cause) {
        super(message, cause);
    }

}
