/*
 * File: CryptoMode.java
 *  
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005-2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.securityframework;


/**
 * An enumeration class to represent the mode in which the CryptoProvider is operating.
 * It can be either FIPS or non FIPS mode.
 * @author mdharan
 *
 */
public enum CryptoMode 
{
	FIPS_MODE(0), NON_FIPS_MODE(1);
	private final int cryptoMode;
	
	
	private CryptoMode(int mode) 
	{
		cryptoMode = mode;
	}
	
	/**
	 * returns the cryptomode. 0 means FIPS mode and 1 means non-FIPS mode. 
	 * @return int
	 */
	int getCryptoMode() 
	{ 
		return cryptoMode; 
	}
	
}
