/* ****************************************************************************
 *
 *	File: SecurityManager.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/
package com.adobe.internal.pdftoolkit.core.securityframework;

import java.util.Map;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;


/**
 * <P>Manages security handlers for a PDF document.</P>
 * <P>Use this interface to add, or find and dispatch, a security  
 * handler for use with a PDF document.</P>
 * <P>Different documents may use different Security Handlers. A single 
 * document may use multiple Security Handlers that implement different crypt filters. Under
 * these conditions the Security Manager must be defined to select 
 * the appropriate Security Handler.</P>
 * Depending on the implementation, an instance of a Security Manager may be 
 * document-specific, or not.
 * 
 * <P>This class is useful <i>only</i> for new (that is, custom) implementations of 
 * Security Handlers and SecurityKey/Lock. Its default functionality is provided by
 * the <I>PDF Java Toolkit</I>.</P>
 * <P><B>Note:</B> Generally, separate Security Managers must be used for encryption and decryption.
 * However, the Security Manager for decryption can be used for both, decryption and encryption.</P>   
 */
public interface SecurityManager 
{
	/**
	 * Get the security handler specified by the parameters.
	 * 
	 * @param filterName the PDF name of the security handler.
	 * @param encryptParams Map that represents the content of the
	 * 						  PDF document's <B>Encrypt</B> dictionary.
	 * @return	<code>SecurityHandler</code> object that implements the requested 						
	 * 			security handler.
	 * @throws PDFSecurityConfigurationException if the appropriate security 
     * handler cannot be found.
 	 */
	public SecurityHandler getSecurityHandler(String filterName, Map encryptParams) 
    throws PDFSecurityConfigurationException;
	
	/**
	 * Add a new security handler to the list of security handlers
	 * supported by this security manager.
	 * 
	 * @param name the PDF name of the security handler.
	 * @param handler SecurityHandler object.
	 */
	public void addSecurityHandler(String name, SecurityHandler handler);		
}
