/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2006, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be coveredby   */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm.io;

import java.io.IOException;

import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCType;

/**
 * @author <a href="mailto:tnaroska@adobe.com">tnaroska</a>
 * @version $Revision: #1 $
 * @since Mar 8, 2006
 */
public interface ISerializer
{
	// ----------------------------------------------------------------------------------- Constants

	/** key used in handshake dictionary */
	String HANDSHAKE_VERSION = "version";

	/** key used in handshake dictionary */
	String HANDSHAKE_PROTO = "protocol";

	/** key used in handshake dictionary */
	String HANDSHAKE_CLIENT_ID = "client-id";

	/** key used in handshake dictionary */
	String HANDSHAKE_PROCESS_ID = "pid";

	// ------------------------------------------------------------------------------------- Methods

	/** @return the handshake dictionary */
	NCMap handshake();

	/**
	 * Reads a <code>NCType</code> object from a DataInput.
	 * 
	 * @return a <code>NCType</code> object from the specified DataInput
	 * @exception IOException on I/O failure
	 */
	NCType read() throws IOException;

	/**
	 * Writes an <code>NCType</code> object to a DataOutput.
	 * 
	 * @param val NCType to write
	 * @return the Serializer
	 * @exception IOException on I/O failure
	 */
	ISerializer write(NCType val) throws IOException;

	/**
	 * Flush buffered data if any
	 * 
	 * @return the Serializer
	 * @throws IOException on error
	 */
	ISerializer flush() throws IOException;

	/**
	 * Returns true if the ISerializer object is valid
	 * 
	 * @return true if the ISerializer object is valid
	 */
	boolean isValid();

	/**
	 * Close the internal input/output streams
	 * @param sendShutdownMessage - if true sends a shutdown message before disposal
	 */
	void dispose(boolean sendShutdownMessage);
}
