/*
 * File: PropertyAnnotationInfo.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xmp.schema.rng.model;

import com.adobe.xmp.schema.rng.parser.annotation.RNGDecorationAnnotation.ACCESS;

/**
 * An interface which describes storage of information extracted from annotations into PropertyInfo objects.
 * 
 * @author hraghav
 */
public interface PropertyAnnotationInfo
{

	/**
	 * @param mLabel
	 *            the mLabel to set
	 */
	public void setLabel(String mLabel);

	/**
	 * @return the mLabel
	 */
	public String getLabel();

	/**
	 * @param mDescription
	 *            the mDescription to set
	 */
	public void setDescription(String mDescription);

	/**
	 * @return the mDescription
	 */
	public String getDescription();

	/**
	 * @param mAccess
	 *            the mAccess to set
	 */
	public void setAccess(ACCESS mAccess);

	/**
	 * @return the mAccess
	 */
	public ACCESS getAccess();

}
