/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.predicate;

import org.apache.commons.collections.Predicate;
import org.apache.sling.api.adapter.Adaptable;

/**
 * Predicate used to filter resources based on their adaptability.
 */
public class ResourceFilter implements Predicate {

    /**
     * class to filter on
     */
    private final Class filterClass;

    /**
     * Creates a new resource filter for the given class
     * @param filterClass the class to filter on
     */
    public ResourceFilter(Class filterClass) {
        this.filterClass = filterClass;
    }

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if o is a Resource and adapts to the respective
     * filter class.
     */
    @SuppressWarnings("unchecked")
    public boolean evaluate(Object o) {
        return o instanceof Adaptable
                && ((Adaptable) o).adaptTo(filterClass) != null;
    }

}