/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

/**
 * This interface must be implemented by each processor class that is used for
 * post-processing the result data
 */
public interface Processor {

    /**
     * Process the specified row.
     *
     * @param rowToProcess The row to be processed
     * @return <code>true</code> if the row has to be removed from the result set
     */
    boolean processRow(DataRow rowToProcess);

    /**
     * Cleans up the processor.
     */
    void cleanup();

}
