/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting.helpers;

/**
 * This enumeration defines the column types supported by the clientside implementation.
 */
public enum ColumnType {

    /**
     * Value is a String
     */
    STRING("string", DisplayDataType.STRING),

    /**
     * Value is a number
     */
    NUMBER("number", DisplayDataType.NUMBER),

    /**
     * Value is an integer number
     */
    INT("int", DisplayDataType.INT),

    /**
     * Value is a date (= <code>Calendar</code>)
     */
    DATE("date", DisplayDataType.DATE),

    /**
     * Value is a diff of two values
     */
    DIFF("diff", DisplayDataType.NUMBER),

    /**
     * Value is the timeslot of a date property
     */
    TIMESLOT("timeslot", DisplayDataType.CUSTOM),

    /**
     * Value is labeled with a different property
     */
    SORTABLE("sortable", DisplayDataType.CUSTOM);


    /**
     * The string reprsentation used for data transfer
     */
    private final String transferStr;

    /**
     * The display data type for the column type
     */
    private final DisplayDataType displayType;


    /**
     * Creates a new column type.
     *
     * @param transferStr The string representation used for data transfer
     * @param displayType The display type for the column type
     */
    private ColumnType(String transferStr, DisplayDataType displayType) {
        this.transferStr = transferStr;
        this.displayType = displayType;
    }

    /**
     * Gets the string representation used for data transfer.
     *
     * @return The string representation used for data transfer
     */
    public String getTransferStr() {
        return this.transferStr;
    }

    /**
     * Gets the display type for the column type.
     *
     * @return The display type
     */
    public DisplayDataType getDisplayType() {
        return this.displayType;
    }

    /**
     * Gets a suitable <code>ColumnType</code> for the specified transfer representation.
     *
     * @param transferStr The transfer string
     * @return the matching <code>ColumnType</code> for the specified transfer
     *         representation
     */
    public static ColumnType fromTransferString(String transferStr) {
        ColumnType[] values = values();
        for (ColumnType value : values) {
            if (value.getTransferStr().equals(transferStr)) {
                return value;
            }
        }
        return null;
    }

}
