/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.ByteArrayByteWriter;
import com.adobe.internal.io.ByteBufferByteReader;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.ByteReaderInputByteStream;
import com.adobe.internal.io.stream.ByteWriterOutputByteStream;
import com.adobe.internal.io.stream.ChainedInputByteStream;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamDatabase;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class StreamManager {
    private static final boolean ignoreSlicesOfMaster = false;
    private ByteReader masterByteReader;
    private ByteWriterFactory byteWriterFactory;
    private StreamDatabase streamDB;

    private StreamManager(ByteWriterFactory byteWriterFactory, ByteReader masterByteReader) {
        this.byteWriterFactory = byteWriterFactory;
        this.masterByteReader = masterByteReader;
        this.streamDB = new StreamDatabase(masterByteReader, true, true, true);
    }

    public static StreamManager newInstance(ByteWriterFactory byteWriterFactory, ByteReader masterByteReader) {
        return new StreamManager(byteWriterFactory, masterByteReader);
    }

    public void resetMasterByteReader(ByteReader masterByteReader) throws IOException {
        this.masterByteReader = masterByteReader;
        ByteReader oldMasterByteReader = this.streamDB.resetMasterByteReader(masterByteReader);
        if (oldMasterByteReader != null) {
            oldMasterByteReader.close();
        }
    }

    public InputByteStream getInputByteStream(ByteReader byteReader) throws IOException {
        return new ByteReaderInputByteStream(this, byteReader, true);
    }

    public InputByteStream getInputByteStream(ByteReader byteReader, long startOffset, long length) throws IOException {
        return new ByteReaderInputByteStream(this, byteReader, startOffset, length, true);
    }

    public InputByteStream getInputByteStream(byte[] b) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(b);
        ByteBufferByteReader reader = null;
        reader = new ByteBufferByteReader(buffer);
        return this.getInputByteStream(reader);
    }

    public InputByteStream getInputByteStream(InputByteStream[] byteStreams) throws IOException {
        if (byteStreams != null) {
            return new ChainedInputByteStream(byteStreams);
        }
        return null;
    }

    public OutputByteStream getOutputByteStream(ByteWriter byteWriter) throws IOException {
        return new ByteWriterOutputByteStream(this, byteWriter, true);
    }

    public OutputByteStream getUnregisteredOutputByteStream(ByteWriter byteWriter) throws IOException {
        return new ByteWriterOutputByteStream(this, byteWriter, false);
    }

    public OutputByteStream getOutputByteStreamClearTemp(ByteWriterFactory.Fixed fixed, long size) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.TEMPORARY, ByteWriterFactory.EncryptionStatus.CLEAR, fixed, size, false);
    }

    public OutputByteStream getOutputByteStreamEncryptedTemp(ByteWriterFactory.Fixed fixed, long size) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.TEMPORARY, ByteWriterFactory.EncryptionStatus.ENCRYPTED, fixed, size, false);
    }

    public OutputByteStream getOutputByteStreamDecryptedTemp(ByteWriterFactory.Fixed fixed, long size) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.TEMPORARY, ByteWriterFactory.EncryptionStatus.DECRYPTED, fixed, size, false);
    }

    public OutputByteStream getOutputByteStreamClearDocument(ByteWriterFactory.Fixed fixed, long size) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.CLEAR, fixed, size, false);
    }

    public OutputByteStream getOutputByteStreamEncryptedDocument(ByteWriterFactory.Fixed fixed, long size) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.ENCRYPTED, fixed, size, false);
    }

    public OutputByteStream getOutputByteStreamDecryptedDocument(ByteWriterFactory.Fixed fixed, long size) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.DECRYPTED, fixed, size, false);
    }

    public OutputByteStream getUnregisteredOutputByteStream(ByteWriterFactory.Fixed fixed, int size) throws IOException {
        ByteArrayByteWriter byteWriter = null;
        byteWriter = new ByteArrayByteWriter(size);
        ByteWriterOutputByteStream obs = new ByteWriterOutputByteStream(this, byteWriter, false);
        return obs;
    }

    public OutputByteStream getOutputByteStream(ByteWriterFactory.Longevity longevity, ByteWriterFactory.EncryptionStatus encryption, ByteWriterFactory.Fixed fixed, long size, boolean fast) throws IOException {
        ByteWriter byteWriter = this.byteWriterFactory.getByteWriter(longevity, encryption, fixed, size, fast);
        OutputByteStream obs = this.getOutputByteStream(byteWriter);
        return obs;
    }

    public ByteWriter getByteWriter(ByteWriterFactory.Fixed fixed, long size) throws IOException {
        return this.byteWriterFactory.getByteWriter(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.CLEAR, fixed, size, false);
    }

    public void close() throws IOException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean ignoreMaster) throws IOException {
        try {
            this.streamDB.closeAllOpen(ignoreMaster);
        }
        finally {
            try {
                this.byteWriterFactory.closeFactory();
            }
            catch (IOException e) {
                IOException ioe = new IOException("Unable to close the ByteWriterFactory.");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    void deregisterInputByteStream(ByteReaderInputByteStream ibs, ByteReader byteReader, boolean isSlice) throws IOException {
        if (this.streamDB.removeIBS(ibs, byteReader)) {
            try {
                byteReader.close();
            }
            catch (IOException e) {
                IOException ioe = new IOException("Unable to close ByteReader");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    void registerInputByteStream(ByteReaderInputByteStream ibs, ByteReader byteReader, boolean isSlice) {
        this.streamDB.addIBS(ibs, byteReader);
    }

    boolean deregisterOutputByteStream(OutputByteStream obs, ByteWriter byteWriter) throws IOException {
        boolean closeStream = this.streamDB.removeOBS(obs, byteWriter);
        if (closeStream) {
            try {
                this.byteWriterFactory.closeByteWriter(byteWriter);
            }
            catch (IOException e) {
                IOException ioe = new IOException("Unable to close ByteReader");
                ioe.initCause(e);
                throw ioe;
            }
        }
        return closeStream;
    }

    void registerOutputByteStream(ByteWriterOutputByteStream obs, ByteWriter byteWriter) {
        this.streamDB.addOBS(obs, byteWriter);
    }
}

