/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.tags;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.personalization.ClientContextUtil;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

public class StorePropertyTag
extends TagSupport {
    private static final long serialVersionUID = 4646561799994266940L;
    private String propertyName;
    private String store;
    private String prefix;
    private String suffix;
    private String defaultValue = "";

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.prefix = "";
        this.suffix = "";
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        SlingHttpServletRequest request = TagUtil.getRequest(this.pageContext);
        try {
            out.println(this.getScript(request));
        }
        catch (IOException e) {
            throw new JspException("Could not write script for context profile property", e);
        }
        return 6;
    }

    String getScript(SlingHttpServletRequest request) {
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);
        StringBuilder res = new StringBuilder();
        String prefixId = ClientContextUtil.getId(request.getResource().getPath());
        String filteredPropertyName = ClientContextUtil.getId(this.propertyName);
        String id = prefixId + "-" + this.store + "-" + filteredPropertyName;
        res.append("<div");
        res.append(" id=\"").append(xssAPI.encodeForHTMLAttr(id)).append("\"");
        res.append(" class=\"").append(xssAPI.encodeForHTMLAttr("cq-cc-" + this.store)).append(" ").append(xssAPI.encodeForHTMLAttr("cq-cc-" + this.store + "-" + this.propertyName)).append("\"");
        res.append(" title=\"").append(xssAPI.encodeForHTMLAttr("/" + this.store + "/" + this.propertyName)).append("\"");
        res.append(" data-store=\"").append(xssAPI.encodeForHTMLAttr(this.store)).append("\"");
        res.append(" data-property=\"").append(xssAPI.encodeForHTMLAttr(this.propertyName)).append("\"");
        res.append(">");
        res.append("</div>");
        res.append("<script type=\"text/javascript\">\n");
        res.append("if( window.CQ_Analytics ) {");
        res.append("CQ_Analytics.ClientContextUtils.renderStoreProperty(");
        res.append("'").append(xssAPI.encodeForJSString(id)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(this.store)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(this.propertyName)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(this.prefix)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(this.suffix)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(this.defaultValue)).append("'");
        res.append(");");
        res.append("}");
        res.append("</script>");
        return res.toString();
    }
}

