/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.adobe.granite.translation.core.common;

import com.adobe.granite.translation.api.TranslationServiceFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Dictionary;

public abstract class AbstractTranslationServiceFactory implements TranslationServiceFactory {

    protected String factoryName;

    private static final Logger log = LoggerFactory.getLogger(AbstractTranslationServiceFactory.class);

    protected void activate(final ComponentContext ctx) {
        log.debug("Starting function: activate");
        final Dictionary<?, ?> properties = ctx.getProperties();

        factoryName =
            PropertiesUtil.toString(properties.get(TranslationServiceFactory.PROPERTY_TRANSLATION_FACTORY),
                StringUtils.EMPTY);

        if (log.isDebugEnabled()) {
            log.debug("Activated TSF with the following:");
            log.debug("Factory Name: {}", factoryName);
        }
    }

    @Override
    public String getServiceFactoryName() {
        log.trace("Starting function: getServiceFactoryName");
        return factoryName;
    }

}