/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


/**
 * This class contains all the script functionality associated with the
 * TextNode class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class TextNodeScript extends ProtoableNodeScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ProtoableNodeScript.moScriptTable,
		"#text", 
		new ScriptPropObj[] {
			new ScriptPropObj(TextNodeScript.class, "value", "getValue", "setValue", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_TEXT_VALUE, 0 */, 0)
		},
		null
	);
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getValue(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((TextNode) pObj).getValue());
	}

	public static void setValue(Obj pObj, Arg oArg) {
		((TextNode) pObj).setValue(oArg.getString(), true, false);
	}
}
