/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.data;

import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

import com.adobe.xfa.Generator;
import com.adobe.xfa.Node;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.FindBugsSuppress;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.ResId;

/**
 * IncrementalLoadHandler is used by a DataModel in the case
 * when it is in lazy loading mode.  It maintains context information.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public final class IncrementalLoader {
	public int mnLoadNodeLevel;

	private final Generator mGenerator;
	//private DataModel mDataModel;
	private DataNode mStartNode;
//	private jfDomDocument mDomDocument;

	private final List<Node> mParentStack = new ArrayList<Node>();
	private final List<Node> mResumeNodeStack = new ArrayList<Node>();

	private boolean mbBackOut;

	private int mnRecordLevel;

	// Javaport: TODO: Caller should ensure that these are closed (e.g., if an exception is thrown).
	@FindBugsSuppress(pattern="UWF_UNWRITTEN_FIELD")
	private FileOutputStream mXSLStreamFile;
	@FindBugsSuppress(pattern="UWF_UNWRITTEN_FIELD")
	private FileOutputStream mXSLDebugStreamFile;

	
	IncrementalLoader(DataModel dataModel, 
			  DataNode startNode, 
			  Generator generator) {
	    //mDataModel = dataModel;
	    mGenerator = generator;
	    //mbBackOut  = false;
	    //mnLoadNodeLevel = 0;
	    //mnRecordLevel = 0;
	    //mXSLStreamFile = null;
	    //mXSLDebugStreamFile = null;
		mStartNode = startNode;
	//	mDomDocument = startNode.getOwnerDocument();
   		push(dataModel, startNode);
    }
	
//	protected void finalize()	{
//		throw new ExFull(ResId.UNSUPPORTED_OPERATION, "IncrementalLoader.finalize");
//
////		if (mXSLStreamFile != null)
////			mXSLStreamFile = null;
////		if (mXSLDebugStreamFile != null)
////		{
////			// write out the trailer
////			String sTrailer = "</xfa:xsltDebug\n>";
////			mXSLDebugStreamFile.write(sTrailer, false);
////			mXSLDebugStreamFile = null;
////		}
//	}

	// Push parent/node onto the stack
	void push(Node parent, Node nextResumeNode) {
		mParentStack.add(parent);
		mResumeNodeStack.add(nextResumeNode);
	}

	// Pop and discard the top of the stack
	void pop() {
		int size = mParentStack.size();
		assert (size > 0);
		assert (size == mResumeNodeStack.size());
		mParentStack.remove(size - 1);
		mResumeNodeStack.remove(size - 1);
	}

	// Pop and return the top of the stack
	Node getNext(ObjectHolder<Node> nextResumeNode){
		int size = mParentStack.size();
		if (size == 0) {
			// Make this object light-weight by releasing references to the data 
			mStartNode = null;
	//		mDomDocument = null;
			return null;
		}
		Node parent = mParentStack.get(size-1);
		nextResumeNode.value = mResumeNodeStack.get(size-1);
		pop();
		return parent;
	}

	boolean backOut() {
		return mbBackOut;
	}

	void backOut(boolean bBackOut) {
		mbBackOut = bBackOut;
	}

	Generator getGenerator() {
		return mGenerator;
	}

	boolean stackIsEmpty() {
		return mParentStack.size() == 0;
	}

	boolean isStartNode(DataNode node) {
		return mStartNode == node;
	}

	int recordDepth() {
		return mnRecordLevel;
	}

	void recordDepth(int nDepth) {
		mnRecordLevel = nDepth;
	}

	void XSLScriptFile(String scriptFile, String XSLDebugFile, String scriptString /* = "" */){
		throw new ExFull(ResId.UNSUPPORTED_OPERATION, "IncrementalLoader#XSLScriptFile");
	//	if ( scriptFile != "")		// scriptFile overrides scriptString
	//	{
	//		mXSLStreamFile = new jfStreamFile;
	//		mXSLStreamFile->Open(jfFileId(scriptFile), jfFileMode());
	//
	//		createXSLDebugStream(XSLDebugFile);
	//
	//	}
	//	else if ( ! scriptString.IsEmpty())
	//	{
	//		jfMemoryStreamFile* poMemStreamFile = new jfMemoryStreamFile;
	//		
	//		size_t nLength = scriptString.Length();
	//		const char* s = (const char*)scriptString;
	//		
	//		poMemStreamFile->Write((const void *)s, nLength);
	//		mpoXSLStreamFile = poMemStreamFile;
	//
	//		createXSLDebugStream(XSLDebugFile);
	//	}
	}

	FileOutputStream XSLStream() {
		return mXSLStreamFile;
	}

	FileOutputStream XSLDebugStream() {
		return mXSLDebugStreamFile;
	}

	// Public data may not follow the coding standards, but wrapping mnLoadNodeLevel
	// in accessor methods  seems like over-engineering to me...

	void	createXSLDebugStream(String XSLDebugFile) {
		throw new ExFull(ResId.UNSUPPORTED_OPERATION, "IncrementalLoader#createXSLDebugStream");
	//	if ( ! XSLDebugFile.IsEmpty())
	//}
	//{
	//	mpoXSLDebugStreamFile = new jfStreamFile;
	//	mpoXSLDebugStreamFile->Open(XSLDebugFile, jfFileMode(jfFileMode::MODE_WRITE));
	//
	//	// put out the header; this is hard-coded XML
	//	jfString sHeader = 
	//		"<?xml version=\"1.0\" encoding=\"UTF-8\"\n"
	//		"?><xfa:xsltDebug xmlns:xfa=\"http://www.xfa.org/schema/xfa-xslt-debug/1.0/\"\n"
	//		">";
	//	mpoXSLDebugStreamFile->Write(sHeader, FALSE);
	}

}
