package com.adobe.xfa.text.markup;

import java.util.HashMap;
import java.util.Map;


/**
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
abstract public class MarkupAttr {
// This enumeration is intended to cover all text and positioning
// markup commands which may affect the TextAttr appearance and
// behavior.  These are the puppies for which descendents may
// define associated markup text strings.
	public static final int MARKUP_UNKNOWN = 0;
	public static final int MARKUP_NOT_SUPPORTED = MARKUP_UNKNOWN + 1;

// general keywords
	public static final int MARKUP_ALL = MARKUP_NOT_SUPPORTED + 1;
	public static final int MARKUP_AUTO = MARKUP_ALL + 1;
	public static final int MARKUP_NONE = MARKUP_AUTO + 1;
	public static final int MARKUP_NORMAL = MARKUP_NONE + 1;
	public static final int MARKUP_SOLID = MARKUP_NORMAL + 1;

// header info
	public static final int MARKUP_STYLESHEET = MARKUP_SOLID + 1;
	public static final int MARKUP_INFO = MARKUP_STYLESHEET + 1;
	public static final int MARKUP_HEADER = MARKUP_INFO + 1;
	public static final int MARKUP_HEADER_LEFT = MARKUP_HEADER + 1;
	public static final int MARKUP_HEADER_RIGHT = MARKUP_HEADER_LEFT + 1;
	public static final int MARKUP_HEADER_FIRST = MARKUP_HEADER_RIGHT + 1;
	public static final int MARKUP_FOOTER = MARKUP_HEADER_FIRST + 1;
	public static final int MARKUP_FOOTER_LEFT = MARKUP_FOOTER + 1;
	public static final int MARKUP_FOOTER_RIGHT = MARKUP_FOOTER_LEFT + 1;
	public static final int MARKUP_FOOTER_FIRST = MARKUP_FOOTER_RIGHT + 1;
	public static final int MARKUP_CODE_PAGE = MARKUP_FOOTER_FIRST + 1;

// paragraph
	public static final int MARKUP_PARAGRAPH_START = MARKUP_CODE_PAGE + 1;
	public static final int MARKUP_PARAGRAPH_END = MARKUP_PARAGRAPH_START + 1;
	public static final int MARKUP_PARAGRAPH_DEFAULT = MARKUP_PARAGRAPH_END + 1;
	public static final int MARKUP_PARAGRAPH_PLAIN = MARKUP_PARAGRAPH_DEFAULT + 1;
	public static final int MARKUP_BREAK = MARKUP_PARAGRAPH_PLAIN + 1;
	public static final int MARKUP_PICTURE = MARKUP_BREAK + 1;

// control
	public static final int MARKUP_HEX_CHARACTER = MARKUP_PICTURE + 1;
	public static final int MARKUP_UNICODE_CHARACTER = MARKUP_HEX_CHARACTER + 1;
	public static final int MARKUP_UC_COUNT = MARKUP_UNICODE_CHARACTER + 1;
	public static final int MARKUP_DESTINATION_GROUP = MARKUP_UC_COUNT + 1;

// special characters
	public static final int MARKUP_ENDASH = MARKUP_DESTINATION_GROUP + 1;
	public static final int MARKUP_EMDASH = MARKUP_ENDASH + 1;
	public static final int MARKUP_ENSPACE = MARKUP_EMDASH + 1;
	public static final int MARKUP_EMSPACE = MARKUP_ENSPACE + 1;
	public static final int MARKUP_BULLET = MARKUP_EMSPACE + 1;
	public static final int MARKUP_LQUOTE = MARKUP_BULLET + 1;
	public static final int MARKUP_RQUOTE = MARKUP_LQUOTE + 1;
	public static final int MARKUP_LDBLQUOTE = MARKUP_RQUOTE + 1;
	public static final int MARKUP_RDBLQUOTE = MARKUP_LDBLQUOTE + 1;
	public static final int MARKUP_LINE = MARKUP_RDBLQUOTE + 1;

// HTML
	public static final int MARKUP_SPAN = MARKUP_LINE + 1;
	public static final int MARKUP_SPAN_END = MARKUP_SPAN + 1;
	public static final int MARKUP_ANCHOR = MARKUP_SPAN_END + 1;
	public static final int MARKUP_STYLE = MARKUP_ANCHOR + 1;
	public static final int MARKUP_EMBED = MARKUP_STYLE + 1;
	public static final int MARKUP_EMBEDMODE = MARKUP_EMBED + 1;
	public static final int MARKUP_EMBEDTYPE = MARKUP_EMBEDMODE + 1;
	public static final int MARKUP_ROOT = MARKUP_EMBEDTYPE + 1;
	public static final int MARKUP_BODY = MARKUP_ROOT + 1;
	public static final int MARKUP_HTML = MARKUP_BODY + 1;
	public static final int MARKUP_BODY_END = MARKUP_HTML + 1;
	public static final int MARKUP_HTML_END = MARKUP_BODY_END + 1;
	public static final int MARKUP_SPACE_RUN = MARKUP_HTML_END + 1;
	public static final int MARKUP_SPACE_RUN_YES = MARKUP_SPACE_RUN + 1;
	public static final int MARKUP_SPACE_RUN_NO = MARKUP_SPACE_RUN_YES + 1;

// spacing
	public static final int MARKUP_LINE_HEIGHT = MARKUP_SPACE_RUN_NO + 1;
	public static final int MARKUP_CHAR_SPACING = MARKUP_LINE_HEIGHT + 1;
	public static final int MARKUP_WORD_SPACING = MARKUP_CHAR_SPACING + 1;
	public static final int MARKUP_LEADING = MARKUP_WORD_SPACING + 1;

// indentation
	public static final int MARKUP_INDENT_FIRST_LINE = MARKUP_LEADING + 1;
	public static final int MARKUP_INDENT_LEFT = MARKUP_INDENT_FIRST_LINE + 1;
	public static final int MARKUP_INDENT_RIGHT = MARKUP_INDENT_LEFT + 1;
	public static final int MARKUP_OUTDENT = MARKUP_INDENT_RIGHT + 1;
	public static final int MARKUP_SPACE_BEFORE = MARKUP_OUTDENT + 1;
	public static final int MARKUP_SPACE_AFTER = MARKUP_SPACE_BEFORE + 1;
	public static final int MARKUP_LINE_SPACE = MARKUP_SPACE_AFTER + 1;
	public static final int MARKUP_MARGIN = MARKUP_LINE_SPACE + 1;

// font
	public static final int MARKUP_FONT_NAME = MARKUP_MARGIN + 1;
	public static final int MARKUP_FONT_SIZE = MARKUP_FONT_NAME + 1;
	public static final int MARKUP_FONT_WEIGHT = MARKUP_FONT_SIZE + 1;
	public static final int MARKUP_FONT_STYLE = MARKUP_FONT_WEIGHT + 1;
	public static final int MARKUP_FONT = MARKUP_FONT_STYLE + 1;
	public static final int MARKUP_FONT_BOLD = MARKUP_FONT + 1;
	public static final int MARKUP_FONT_ITALIC = MARKUP_FONT_BOLD + 1;
	public static final int MARKUP_FONT_HORIZONTAL_SCALE = MARKUP_FONT_ITALIC + 1;
	public static final int MARKUP_FONT_VERTICAL_SCALE = MARKUP_FONT_HORIZONTAL_SCALE + 1;
	public static final int MARKUP_DEFAULT_FONT = MARKUP_FONT_VERTICAL_SCALE + 1;
	public static final int MARKUP_COLOUR = MARKUP_DEFAULT_FONT + 1;
	public static final int MARKUP_CHARSET = MARKUP_COLOUR + 1;

// effects
	public static final int MARKUP_BOLD = MARKUP_CHARSET + 1;
	public static final int MARKUP_BOLD_END = MARKUP_BOLD + 1;
	public static final int MARKUP_ITALIC = MARKUP_BOLD_END + 1;
	public static final int MARKUP_ITALIC_END = MARKUP_ITALIC + 1;
	public static final int MARKUP_STRIKEOUT = MARKUP_ITALIC_END + 1;
	public static final int MARKUP_STRIKEOUT_DOUBLE = MARKUP_STRIKEOUT + 1;
	public static final int MARKUP_STRIKEOUT_END = MARKUP_STRIKEOUT_DOUBLE + 1;
	public static final int MARKUP_COLOUR_TABLE = MARKUP_STRIKEOUT_END + 1;

// decoration
	public static final int MARKUP_UNDERLINE = MARKUP_COLOUR_TABLE + 1;
	public static final int MARKUP_UNDERLINE_DOUBLE = MARKUP_UNDERLINE + 1;
	public static final int MARKUP_UNDERLINE_WORD = MARKUP_UNDERLINE_DOUBLE + 1;
	public static final int MARKUP_UNDERLINE_WORD_DOUBLE = MARKUP_UNDERLINE_WORD + 1;
	public static final int MARKUP_UNDERLINE_ALL = MARKUP_UNDERLINE_WORD_DOUBLE + 1;
	public static final int MARKUP_UNDERLINE_END = MARKUP_UNDERLINE_ALL + 1;
	public static final int MARKUP_UNDERLINE_END2 = MARKUP_UNDERLINE_END + 1;
	public static final int MARKUP_UNDERLINE_TAG = MARKUP_UNDERLINE_END2 + 1;
	public static final int MARKUP_TEXT_UNDERLINE = MARKUP_UNDERLINE_TAG + 1;
	public static final int MARKUP_TEXT_UNDERLINE_STYLE = MARKUP_TEXT_UNDERLINE + 1;
	public static final int MARKUP_TEXT_UNDERLINE_MODE = MARKUP_TEXT_UNDERLINE_STYLE + 1;
	public static final int MARKUP_UNDERLINE_DOTTED = MARKUP_TEXT_UNDERLINE_MODE + 1;
	public static final int MARKUP_UNDERLINE_DASH = MARKUP_UNDERLINE_DOTTED + 1;
	public static final int MARKUP_UNDERLINE_DASH_DOT = MARKUP_UNDERLINE_DASH + 1;
	public static final int MARKUP_UNDERLINE_DASH_DOT_DOT = MARKUP_UNDERLINE_DASH_DOT + 1;
	public static final int MARKUP_UNDERLINE_HEAVY_WAVE = MARKUP_UNDERLINE_DASH_DOT_DOT + 1;
	public static final int MARKUP_UNDERLINE_LONG_DASH = MARKUP_UNDERLINE_HEAVY_WAVE + 1;
	public static final int MARKUP_UNDERLINE_THICK = MARKUP_UNDERLINE_LONG_DASH + 1;
	public static final int MARKUP_UNDERLINE_THICK_DOT = MARKUP_UNDERLINE_THICK + 1;
	public static final int MARKUP_UNDERLINE_THICK_DASH = MARKUP_UNDERLINE_THICK_DOT + 1;
	public static final int MARKUP_UNDERLINE_THICK_DASH_DOT = MARKUP_UNDERLINE_THICK_DASH + 1;
	public static final int MARKUP_UNDERLINE_THICK_DASH_DOT_DOT = MARKUP_UNDERLINE_THICK_DASH_DOT + 1;
	public static final int MARKUP_UNDERLINE_THICK_LONG_DASH = MARKUP_UNDERLINE_THICK_DASH_DOT_DOT + 1;
	public static final int MARKUP_UNDERLINE_DOUBLE_WAVE = MARKUP_UNDERLINE_THICK_LONG_DASH + 1;
	public static final int MARKUP_UNDERLINE_WAVE = MARKUP_UNDERLINE_DOUBLE_WAVE + 1;
	public static final int MARKUP_TEXT_DECORATION = MARKUP_UNDERLINE_WAVE + 1;

// baseline shift
	public static final int MARKUP_BASELINE_SHIFT = MARKUP_TEXT_DECORATION + 1;
	public static final int MARKUP_BASELINE = MARKUP_BASELINE_SHIFT + 1;
	public static final int MARKUP_SUPER = MARKUP_BASELINE + 1;
	public static final int MARKUP_SUPER_END = MARKUP_SUPER + 1;
	public static final int MARKUP_SUB = MARKUP_SUPER_END + 1;
	public static final int MARKUP_SUB_END = MARKUP_SUB + 1;
	public static final int MARKUP_DOWN = MARKUP_SUB_END + 1;
	public static final int MARKUP_UP = MARKUP_DOWN + 1;

// alignment/justification
	public static final int MARKUP_JUSTIFY = MARKUP_UP + 1;
	public static final int MARKUP_JUSTIFY_SPREAD = MARKUP_JUSTIFY + 1;
	public static final int MARKUP_JUSTIFY_SPREAD_ALL = MARKUP_JUSTIFY_SPREAD + 1;
	public static final int MARKUP_JUSTIFY_HORZ_LEFT = MARKUP_JUSTIFY_SPREAD_ALL + 1;
	public static final int MARKUP_JUSTIFY_HORZ_CENTER = MARKUP_JUSTIFY_HORZ_LEFT + 1;
	public static final int MARKUP_JUSTIFY_HORZ_RIGHT = MARKUP_JUSTIFY_HORZ_CENTER + 1;
	public static final int MARKUP_JUSTIFY_COMB_LEFT = MARKUP_JUSTIFY_HORZ_RIGHT + 1;
	public static final int MARKUP_JUSTIFY_COMB_CENTER = MARKUP_JUSTIFY_COMB_LEFT + 1;
	public static final int MARKUP_JUSTIFY_COMB_RIGHT = MARKUP_JUSTIFY_COMB_CENTER + 1;
	public static final int MARKUP_TEXT_VALIGN = MARKUP_JUSTIFY_COMB_RIGHT + 1;
	public static final int MARKUP_TEXT_VALIGN_TOP = MARKUP_TEXT_VALIGN + 1;
	public static final int MARKUP_TEXT_VALIGN_MIDDLE = MARKUP_TEXT_VALIGN_TOP + 1;
	public static final int MARKUP_TEXT_VALIGN_BOTTOM = MARKUP_TEXT_VALIGN_MIDDLE + 1;
	public static final int MARKUP_JUSTIFY_VERT = MARKUP_TEXT_VALIGN_BOTTOM + 1;
	public static final int MARKUP_JUSTIFY_VERT_TOP = MARKUP_JUSTIFY_VERT + 1;
	public static final int MARKUP_JUSTIFY_VERT_CENTER = MARKUP_JUSTIFY_VERT_TOP + 1;
	public static final int MARKUP_JUSTIFY_VERT_BOTTOM = MARKUP_JUSTIFY_VERT_CENTER + 1;
	public static final int MARKUP_TAB = MARKUP_JUSTIFY_VERT_BOTTOM + 1;

// tabs
	public static final int MARKUP_TAB_DEFAULT = MARKUP_TAB + 1;
	public static final int MARKUP_TAB_POSITION = MARKUP_TAB_DEFAULT + 1;
	public static final int MARKUP_TAB_ALIGN_LEFT = MARKUP_TAB_POSITION + 1;
	public static final int MARKUP_TAB_ALIGN_CENTER = MARKUP_TAB_ALIGN_LEFT + 1;
	public static final int MARKUP_TAB_ALIGN_RIGHT = MARKUP_TAB_ALIGN_CENTER + 1;
	public static final int MARKUP_TAB_ALIGN_DECIMAL = MARKUP_TAB_ALIGN_RIGHT + 1;
	public static final int MARKUP_TAB_COUNT = MARKUP_TAB_ALIGN_DECIMAL + 1;

// units
	public static final int MARKUP_CM = MARKUP_TAB_COUNT + 1;
	public static final int MARKUP_PT = MARKUP_CM + 1;
	public static final int MARKUP_INCHES = MARKUP_PT + 1;
	public static final int MARKUP_MM = MARKUP_INCHES + 1;

// style
	public static final int MARKUP_STYLE_REF = MARKUP_MM + 1;
	public static final int MARKUP_CHARACTER_STYLE = MARKUP_STYLE_REF + 1;
	public static final int MARKUP_STYLE_ADDITIVE = MARKUP_CHARACTER_STYLE + 1;
	public static final int MARKUP_STYLE_BASED_ON = MARKUP_STYLE_ADDITIVE + 1;

// tables
	public static final int MARKUP_TABLE_ROW = MARKUP_STYLE_BASED_ON + 1;
	public static final int MARKUP_TABLE_CELL = MARKUP_TABLE_ROW + 1;

// div
	public static final int MARKUP_DIV = MARKUP_TABLE_CELL + 1;
	public static final int MARKUP_DIV_END = MARKUP_DIV + 1;

// xhtml
	public static final int MARKUP_XHTML_LEFT = MARKUP_DIV_END + 1;
	public static final int MARKUP_XHTML_CENTER = MARKUP_XHTML_LEFT + 1;
	public static final int MARKUP_XHTML_RIGHT = MARKUP_XHTML_CENTER + 1;

// digit display
	public static final int MARKUP_DIGITS = MARKUP_XHTML_RIGHT + 1;
	public static final int MARKUP_DIGITS_DEFAULT = MARKUP_DIGITS + 1;
	public static final int MARKUP_DIGITS_ARABIC = MARKUP_DIGITS_DEFAULT + 1;
	public static final int MARKUP_DIGITS_INDIC = MARKUP_DIGITS_ARABIC + 1;

// neutral character direction
	public static final int MARKUP_DIRECTION = MARKUP_DIGITS_INDIC + 1;
	public static final int MARKUP_DIRECTION_NEUTRAL = MARKUP_DIRECTION + 1;
	public static final int MARKUP_DIRECTION_LTR = MARKUP_DIRECTION_NEUTRAL + 1;
	public static final int MARKUP_DIRECTION_RTL = MARKUP_DIRECTION_LTR + 1;

// ligatures
	public static final int MARKUP_LIGATURE = MARKUP_DIRECTION_RTL + 1;
	public static final int MARKUP_LIGATURE_MINIMUM = MARKUP_LIGATURE + 1;
	public static final int MARKUP_LIGATURE_COMMON = MARKUP_LIGATURE_MINIMUM + 1;

// kerning
	public static final int MARKUP_KERNING_MODE = MARKUP_LIGATURE_MINIMUM + 1;
	public static final int MARKUP_KERN_PAIR = MARKUP_KERNING_MODE + 1;

// hyphenation
	public static final int MARKUP_HYPHENATION = MARKUP_KERN_PAIR + 1;
	public static final int MARKUP_HYPHENATION_LEVEL = MARKUP_HYPHENATION + 1;
	public static final int MARKUP_HYPHENATION_PREFERRED = MARKUP_HYPHENATION_LEVEL + 1;
	public static final int MARKUP_HYPHENATION_LENGTH = MARKUP_HYPHENATION_PREFERRED + 1;
	public static final int MARKUP_HYPHENATION_ACRONYMS = MARKUP_HYPHENATION_LENGTH + 1;
	public static final int MARKUP_HYPHENATION_NAMES = MARKUP_HYPHENATION_ACRONYMS + 1;

	public static final int MARKUP_LEADER_ALIGN = MARKUP_HYPHENATION_NAMES + 1;
	public static final int MARKUP_LEADER_ALIGN_PAGE = MARKUP_LEADER_ALIGN + 1;
	public static final int MARKUP_LEADER_PATTERN = MARKUP_LEADER_ALIGN_PAGE + 1;
	public static final int MARKUP_LEADER_PATTERN_SPACE = MARKUP_LEADER_PATTERN + 1;
	public static final int MARKUP_LEADER_PATTERN_RULE = MARKUP_LEADER_PATTERN_SPACE + 1;
	public static final int MARKUP_LEADER_PATTERN_DOTS = MARKUP_LEADER_PATTERN_RULE + 1;
	public static final int MARKUP_LEADER_PATTERN_USE_CONTENT = MARKUP_LEADER_PATTERN_DOTS + 1;
	public static final int MARKUP_LEADER_PATTERN_USE_CONTENT2 = MARKUP_LEADER_PATTERN_USE_CONTENT + 1;
	public static final int MARKUP_LEADER_PATTERN_WIDTH = MARKUP_LEADER_PATTERN_USE_CONTENT2 + 1;
	public static final int MARKUP_RULE_STYLE = MARKUP_LEADER_PATTERN_WIDTH + 1;
	public static final int MARKUP_RULE_STYLE_DOTTED = MARKUP_RULE_STYLE + 1;
	public static final int MARKUP_RULE_STYLE_DASHED = MARKUP_RULE_STYLE_DOTTED + 1;
	public static final int MARKUP_RULE_THICKNESS = MARKUP_RULE_STYLE_DASHED + 1;

	public static final int MARKUP_ENUM_MAX = MARKUP_RULE_STYLE_DASHED + 1;

// Data
	protected final Map<Integer, String> moMarkupMap = new HashMap<Integer, String>();
	protected final Map<String, Integer> moTagMap = new HashMap<String, Integer>();

	public MarkupAttr () {
	}

	public String lookup (int eTag) {
		String value = moMarkupMap.get(eTag);
		return value == null ? "" : value;
	}

	public int lookup (String oMarkup) {
		Integer value = moTagMap.get(oMarkup);
		return value == null ? MARKUP_UNKNOWN : value.intValue();
	}

	public int extractTag (StringBuilder oStrSource) {
		StringBuilder oStrTemp = new StringBuilder (oStrSource.toString());
		int eTag;

// Handle hex character differently
		if (oStrTemp.charAt (0) == '\'') {
			oStrTemp.append ('\'');
		} else {
			while (oStrTemp.length() > 0) {
				int last = oStrTemp.length() - 1;
				char c = oStrTemp.charAt (last);
				if (((c >= '0') && (c <= '9')) || (c == '-')) {
					break;
				}
// Remove all trailing digits
				oStrTemp.deleteCharAt (last);
			}
		}

		eTag = lookup (oStrTemp.toString());

		if (eTag != MARKUP_UNKNOWN) {
			oStrSource.delete (0, oStrTemp.length());
		}

		return eTag;
	}

	public boolean hasBlockScoping () {
		return true;
	}

	public boolean hasParagraphAttr () {
		return true;
	}

// Parsing/text generation attributes.
	abstract public char blockPrefix ();
	abstract public char blockSuffix ();
	abstract public char commandPrefix ();
	abstract public char delimiter ();
	abstract public boolean isDelimiter (char c);

	public char disablingChar () {
		return ' ';
	}

	public char enablingChar () {
		return ' ';
	}

	public int pointSizeFactor () {
		return 1;
	}

	abstract public boolean isValidMarkup (String sRtf);

	public String whiteSpace () {
		return " \t\r\n";	// TODO: used to get from jfString
	}

	protected void setEntry (int eTag, String oStrMarkup, boolean bHasParameter) {
		setMarkupEntry (eTag, oStrMarkup);
		setTagEntry (oStrMarkup, eTag, bHasParameter);
	}
	protected void setEntry (int eTag, String oStrMarkup) {
		setEntry (eTag, oStrMarkup, false);
	}

	protected void setMarkupEntry (int eTag, String oStrMarkup) {
		moTagMap.remove (oStrMarkup);
		moTagMap.put (oStrMarkup, Integer.valueOf(eTag));
	}

	protected void setTagEntry (String oStrMarkup, int eTag, boolean bHasParameter) { /*=FALSE*/
		StringBuilder oStrMarkupEntry = new StringBuilder(); //  = "\\";
		char c;
		c = commandPrefix();
		if (c != '\0') {
			oStrMarkupEntry.append (c);
		}

// Prepend the string with the commmand prefix and append the delimiter
// iff there is no associated parameter.
		oStrMarkupEntry.append (oStrMarkup);
		if (! bHasParameter) {
			c = delimiter();
			if (c != '\0') {
				oStrMarkupEntry.append (c);
			}
		}
		setStringEntry (eTag, oStrMarkupEntry.toString());
	}

	protected void setCharEntry (int eTag, char cMarkup) {
		String sStrMarkup = "";
		sStrMarkup += cMarkup;

		setMarkupEntry (eTag, sStrMarkup);
		setStringEntry (eTag, sStrMarkup);
	}

	protected void setStringEntry (int eTag, String sStrMarkup) {
		setMarkupEntry (eTag, sStrMarkup);

		Integer tag = Integer.valueOf(eTag);
		moMarkupMap.remove (tag);
		moMarkupMap.put (tag, sStrMarkup);
	}
}
