/*
 * File: RNGInvalidSchemaException.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xmp.schema.rng.parser.exceptions;

import org.kohsuke.rngom.rngparser.parse.IllegalSchemaException;

/**
 * Wrapper over an IllegalSchemaException exception.
 * @author hraghav
 */
public class RNGInvalidSchemaException extends Exception
{
	private static final long serialVersionUID = 404637001857647896L;

	/**
	 * 
	 * Constructs a new RNGInvalidSchemaException.
	 *
	 * @param ex Underlying {@link IllegalSchemaException} 
	 */
	public RNGInvalidSchemaException(IllegalSchemaException ex)
	{
		super("A voilation of RNG spec found while parsing RelaxNG schema", ex);
	}
	
}
