/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.api;

import java.util.List;

import com.day.cq.dam.indd.PageBuilder;
import com.day.cq.dam.indd.PageComponent;

/**
 * Interface for classes that provide page components
 */
public interface PageComponentProvider {

    /**
     * The list of page components that this provider provides.
     * 
     * @return The list of page components
     */
    List<PageComponent> getPageComponents();

    /**
     * Setter for injecting the page builder which is used for building page components.
     * 
     * @param pageBuilder
     */
    void setPageBuilder(PageBuilder pageBuilder);

}
