/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.resource.details;

import com.day.cq.dam.api.AssetReferenceResolver;

import javax.jcr.RepositoryException;


/**
 * Class which gives access to some details of a resource
 */
public interface ResourceDetails {

    /**
     * Get name
     */
    public String getName() throws RepositoryException;

    /**
     * Get last modified
     */
    public long getLastModified() throws RepositoryException;

    /**
     * Calculate references
     */
    public int getReferencesSize(AssetReferenceResolver customResolver) throws RepositoryException;

    /**
     * Get comments size
     */
    public int getCommentsSize() throws RepositoryException;

}
