/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.export.json;

import javax.annotation.Nonnull;

import org.osgi.annotation.versioning.ConsumerType;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the JSON export of a component.
 *
 * <p>
 * This interface is aimed at being implemented by Sling Model classes that should provide a JSON export for their corresponding component.
 * </p>
 * <p>
 * <strong>NOTE</strong>: Getter methods' names are all prefixed to avoid name conflicts with methods from the implementation class.
 * </p>
 */
@ConsumerType
@JsonInclude(JsonInclude.Include.NON_NULL)
public interface ComponentExporter {

    /**
     * <p>
     * Returns the type of the resource for which the export is performed.
     * </p>
     * <p>
     * <strong>NOTE:</strong> methods whose JSON serialization would lead to the same JSON property name (":type") <i>will
     * <strong>not</strong> be serialized</i>.
     * </p>
     *
     * @return the type of the component
     */
    @Nonnull
    @JsonProperty(ExporterConstants.PN_TYPE)
    String getExportedType();

}
