/*
*
*	File: OutlineConsumer.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2007 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font;

/** Receives events for unhinted beziers representing glyphs.
 * 
 * There is one event for lines, one event for curves, and one event
 * for moves. The path will be closed after the final event. The
 * fill will be to the left when walking in the direction of the path
 * unless the glyph is malformed.
 * 
 * The coordinates are in the design space of the font. 
 */
public interface OutlineConsumer {
	
  /** 
   * Tells the OutlineConsumer the matrix to be applied to subsequent
   * points in order to get to a 1 ppem size. It is possible for setMatrix
   * to be called multiple times for a single glyph. Each call replaces the 
   * previous matrix. It is guaranteed that setMatrix will be called prior to
   * any other methods. 
   * 
   * @param newMatrix
   */
  public void setMatrix (Matrix newMatrix);
  
  /**
   * Called to set a new currentpoint. If lineto or curveto was
   * previously been called and was the most recent function called, 
   * an implied lineto should precede this move
   * and should close the previous segment by connecting the last point in the
   * most recent line/curve with the point that started the last segment.
   * @param x the x coordinate of the new currentpoint
   * @param y the y coordinate of the new currentpoint
   */
  public void moveto (double x, double y);
  
  /** Called for a line.
   * The line goes from the current point to
   * (<code>x</code>, <code>y</code>). After this call, the currentpoint
   * should be x,y
   */
  public void lineto (double x, double y);

  /** Called for a cubic curve.
   * The control points are the current point, 
   * (<code>x2</code>, <code>y2</code>),
   * (<code>x3</code>, <code>y3</code>),
   * (<code>x4</code>, <code>y4</code>). After this call, the
   * currentpoint should be x4, y4.
   */
  public void curveto (double x2, double y2,
                       double x3, double y3, double x4, double y4);
  
  /** Called for a quadratic curve.
   * The control points are the current point, 
   * (<code>x2</code>, <code>y2</code>),
   * (<code>x3</code>, <code>y3</code>). After this call, the
   * currentpoint should be x3, y3.
   */
  public void curveto (double x2, double y2,
                       double x3, double y3);
  
  /** Called to signal the end of a glyph's outline.
   * 
   * The last path will already be closed by the time this is called. 
   */
  public void endchar();
}
