/*
 * File: OTDevanagariFormatter.java
 * 
 *      ADOBE CONFIDENTIAL
 *      ___________________
 *
 *      Copyright 2004-2005 Adobe Systems Incorporated
 *      All Rights Reserved.
 *
 *      NOTICE: All information contained herein is, and remains the property of
 *      Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *      and technical concepts contained herein are proprietary to Adobe Systems
 *      Incorporated and its suppliers and may be covered by U.S. and Foreign
 *      Patents, patents in process, and are protected by trade secret or
 *      copyright law. Dissemination of this information or reproduction of this
 *      material is strictly forbidden unless prior written permission is obtained
 *      from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;

final class DevanagariFormatter extends IndicFormatter {

  protected int splitVowelsAndNormalize (AttributedRun run, int start, int limit) {

    // normalization: RRA ZWJ -> RA VIRAMA ZWJ, because that is the form
    // wanted by OpenType.
    
    while (start < limit) {
      int usv = run.elementAt (start);
      switch (usv) {
        case 0x0931: {
          if (   start + 1 < limit 
              && run.elementAt (start + 1) == 0x094D) {
            run.replace (new int[] {start, start + 1}, new int[] {0x0930, 0x094D, 0x200D});
            limit++;
            start += 3; }}
        default: {
          start ++; }}}
    
    return limit;
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#nukta()
   */
  protected int nukta () {
    return 0x093C;
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#virama()
   */
  protected int virama () {
    return 0x94D;
  }
  
  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#isConsonant(int)
   */
  protected boolean isConsonant (int usv) {
    return (   0x915 <= usv && usv <= 0x939
            || 0x958 <= usv && usv <= 0x95F
            || 0x25cc == usv);
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#hasNukta(int)
   */
  protected boolean hasNukta (int usv) {
    return (   0x929 == usv
            || 0x931 == usv
            || 0x934 == usv
            || 0x958 <= usv && usv <= 0x95F);
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#removeNukta(int)
   */
  protected int removeNukta (int usv) {
    switch (usv) {
    case 0x929: return 0x928;
    case 0x931: return 0x930;
    case 0x934: return 0x933;
    case 0x958: return 0x915;
    case 0x959: return 0x916;
    case 0x95A: return 0x917;
    case 0x95B: return 0x91C;
    case 0x95C: return 0x921;
    case 0x95D: return 0x93C;
    case 0x95E: return 0x92B;
    case 0x95F: return 0x92F;
    default:    return usv; }
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#isMark(int)
   */
  protected boolean isMark (int usv) {
    return (   0x093E <= usv && usv <= 0x094C
            || 0x0962 <= usv && usv <= 0x963 
            || 0x0901 <= usv && usv <= 0x903
            || 0x0951 <= usv && usv <= 0x954);
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#isIndependentVowel(int)
   */
  protected boolean isIndependentVowel (int usv) {
    return (   0x0904 <= usv && usv <= 0x0914
            || 0x0960 <= usv && usv <= 0x0961
            || 0x25cc == usv);
  }

  
  protected Position getPosition (int usv) {
    switch (usv) {
      case 0x93f: return Position.left;

      case 0x945:
      case 0x946:
      case 0x947:
      case 0x948: return Position.topMatra;
      
      case 0x901:
      case 0x902:
      case 0x951:
      case 0x953:
      case 0x954: return Position.topOther;
      
      case 0x941:
      case 0x942:
      case 0x943:
      case 0x944:
      case 0x952:
      case 0x962:
      case 0x963: return Position.bottom;
          
      case 0x93e:
      case 0x940:
      case 0x949:
      case 0x94a:
      case 0x94b:
      case 0x94c: return Position.rightMatra;
      
      case 0x903: return Position.rightOther;
      
      default:    return Position.any; }
  }
  
  protected Shape rephLike (int usv) {
    if (usv == 0x930) {
      return Shape.rephVowel; }
    else {
      return Shape.any; }
  }
  
  protected boolean subjoins (int usv) {
    return usv == 0x930;
  }
  
  protected boolean postjoins (int usv) {
    return false;
  }

  protected boolean postjoinsIndependentVowels (int usv) {
    return false;
  }
}
