/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/

package com.day.cq.dam.scene7.api.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Scene7AssetSetMember {
    public enum Type {
        // basic
        IMAGE,
        IMAGESET,
        RENDERSET,
        SPINSET,
        SPINSET2D,
        REMIX,
        VIDEO,
        VIEWERSWF,
        MULTIBITRATEVIDEOSET,

        // complex
        SPIN_SET_ROW,

        // other
        OTHER;

        private static final Map<Type,String> MAPPINGS = new HashMap<>();
        static {
            MAPPINGS.put(IMAGE, "advanced_image");
            MAPPINGS.put(IMAGESET, "advanced_imageset");
            MAPPINGS.put(RENDERSET, "advanced_swatchset");
            MAPPINGS.put(SPINSET, "spin");
            MAPPINGS.put(SPINSET2D, "spin");
            MAPPINGS.put(REMIX, "video");
            MAPPINGS.put(VIDEO, "video");
            MAPPINGS.put(VIEWERSWF, "video");
            MAPPINGS.put(MULTIBITRATEVIDEOSET, "video_set");
            MAPPINGS.put(SPIN_SET_ROW, "SpinSetRow");
        }

        public String toString() {
            return MAPPINGS.get(this);
        }

        static Type from(String value) {
            switch(value) {
                case "advanced_image": return IMAGE;
                case "advanced_imageset": return IMAGESET;
                case "advanced_swatchset": return RENDERSET;
                case "spin": return SPINSET;
                case "video": return VIDEO;
                case "video_set": return MULTIBITRATEVIDEOSET;
                case "SpinSetRow": return SPIN_SET_ROW;
                default:
                    final String msg = "\"%s\" is not a valid value";
                    throw new IllegalArgumentException(String.format(msg, value));
            }
        }
    }

    private final Type type;
    private final List<String> handles;

    public Scene7AssetSetMember(Type type, List<String> handles) {
        this.type = type;
        this.handles = handles != null ? handles : new LinkedList<String>();
    }

    public Scene7AssetSetMember(String type, List<String> handles) {
        this(Type.from(type), handles);
    }

    public Type getType() {
        return this.type;
    }

    public List<String> getHandles() {
        return this.handles;
    }
}
