/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.personalization;

import com.adobe.granite.security.user.UserProperties;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * The <code>UserPropertiesProvider</code> interface describes access to {@link UserProperties} via request or {@link
 * ResourceResolver}.
 */
public interface UserPropertiesProvider {

    static final String DEFAULT_USERPROPS_PATH = "profile";

    /**
     * Extract the {@link UserProperties} based on the given <code>request</code>.
     *
     * @param request The request from which to extract user properties.
     *
     * @return The {@link UserProperties} or <code>null</code> if not found.
     */
    UserProperties getUserProperties(SlingHttpServletRequest request);

    /**
     * Extract the {@link UserProperties} based on the given <code>resolver</code>.
     *
     * @param resolver The ResourceResolver from which to extract user properties.
     *
     * @return The {@link UserProperties} or <code>null</code> if not found.
     */
    UserProperties getUserProperties(ResourceResolver resolver);
}
