/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

/**
 * This enumeration defines the phases of filtering,
 */
public enum FilteringPhase {

    /**
     * Filtering is applied on raw data
     */
    RAW("raw"),

    /**
     * Filtering is applied on data that has already been pre-processed using
     * the configured {@link Processor}s
     */
    PREPROCESSED("preprocessed"),

    /**
     * Filtering is applied on data that has been resolved using the configured
     * {@link ValueResolver}s
     */
    RESOLVED("resolved");

    /**
     * String used to identify the phase
     */
    private String transferStr;

    /**
     * Internal constructor.
     *
     * @param transferStr String used to identify the phase
     */
    private FilteringPhase(String transferStr) {
        this.transferStr = transferStr;
    }

    /**
     * Gets the string representation used for data transfer.
     *
     * @return The string representation used for data transfer
     */
    public String getTransferStr() {
        return this.transferStr;
    }

    /**
     * Gets a suitable <code>FilteringPhase</code> for the specified transfer
     * representation.
     *
     * @param transferStr The transfer string
     * @return the matching <code>FilteringPhase</code> for the specified transfer
     *         representation
     */
    public static FilteringPhase fromTransferString(String transferStr) {
        FilteringPhase[] values = values();
        for (FilteringPhase value : values) {
            if (value.getTransferStr().equals(transferStr)) {
                return value;
            }
        }
        return null;
    }

}
