/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.api;

import javax.jcr.RepositoryException;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Authoring UI mode service provides helpers to get and edit authoring UI
 * mode, as well as to get the corresponding editor URL.
 */
public interface AuthoringUIModeService {

    /**
     * Get authoring UI mode
     *
     * @param slingRequest The Sling HTTP request
     * @return Authoring UI mode
     */
    public AuthoringUIMode getAuthoringUIMode(SlingHttpServletRequest slingRequest);

    /**
     * Get authoring UI mode from the sent cookie
     * 
     * @param slingRequest <code>SlingHttpServletRequest</code>
     * @return Authoring UI mode
     */
    public AuthoringUIMode getAuthoringUIModeFromCookie(SlingHttpServletRequest slingRequest);

    /**
     * Get authoring UI mode from the user preferences
     * 
     * @param slingRequest <code>SlingHttpServletRequest</code>
     * @return Authoring UI mode
     */
    public AuthoringUIMode getAuthoringUIModeFromUserPreferences(SlingHttpServletRequest slingRequest);

    /**
     * Get authoring UI mode from OSGI config
     * 
     * @param slingRequest <code>SlingHttpServletRequest</code>
     * @return Authoring UI mode
     */
    public AuthoringUIMode getAuthoringUIModeFromOSGIConfig(SlingHttpServletRequest slingRequest);

    /**
     * Get editor URL for provided authoring UI mode
     *
     * @param authoringUIMode The authoring UI mode
     * @return Editor URL for provided authoring UI mode
     */
    public String getEditorURL(AuthoringUIMode authoringUIMode);

    /**
     * Permanently set user's authoring UI mode
     *
     * @param resolver        The Sling resource resolver
     * @param userId          The ID of the user which authoring UI mode should be changed
     * @param authoringUIMode The user's new authoring UI mode
     * @param save            Set to <code>true</code> if the change should be saved immediately.
     * @throws javax.jcr.RepositoryException This exception is thrown for repository access related issues.
     */
    public void setUserAuthoringUIMode(ResourceResolver resolver, String userId, AuthoringUIMode authoringUIMode, boolean save) throws RepositoryException;

}
