/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.msm.ui.models.blueprintconfig;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.Page;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class})
public class BlueprintColumnItem {
    @ScriptVariable
    private Resource resource;
    private boolean isPage;
    private String imgSrc;
    private String title;
    private Map<String, String> itemAttrb;
    @ScriptVariable
    private XSSAPI xssAPI;
    @Self
    private SlingHttpServletRequest request;

    @PostConstruct
    public void postConstruct() throws Exception {
        Page page = this.resource.adaptTo(Page.class);
        this.isPage = false;
        if (page != null) {
            this.isPage = true;
            this.imgSrc = this.xssAPI.getValidHref(this.request.getContextPath() + this.getThumbnailUrl(page, 48, 48));
            this.title = page.getTitle() == null ? page.getName() : page.getTitle();
        } else {
            ValueMap resourceValueMap = this.resource.getValueMap();
            this.title = resourceValueMap.get("jcr:content/jcr:title", resourceValueMap.get("jcr:title", this.resource.getName()));
        }
        this.title = this.xssAPI.encodeForHTML(this.title);
        this.itemAttrb = new HashMap<String, String>();
        this.itemAttrb.put("class", "foundation-collection-item coral3-ColumnView-item");
        this.itemAttrb.put("data-foundation-collection-item-id", this.resource.getPath());
        this.itemAttrb.put("data-granite-collection-item-id", this.resource.getPath());
        if (this.resource.hasChildren()) {
            this.itemAttrb.put("variant", "drilldown");
        }
    }

    public boolean isPage() {
        return this.isPage;
    }

    public boolean isValidSelection() {
        return this.isPage;
    }

    public String getImageSource() {
        return this.imgSrc;
    }

    public Map<String, String> getItemAttrb() {
        return this.itemAttrb;
    }

    public String getTitle() {
        return this.title;
    }

    private String getThumbnailUrl(Page page, int width, int height) {
        Calendar cal;
        String ck = "";
        ValueMap metadata = page.getProperties("image/file/jcr:content");
        if (metadata != null && (cal = (Calendar)((Object)metadata.get("jcr:lastModified", Calendar.class))) != null) {
            ck = "" + cal.getTimeInMillis() / 1000L;
        }
        return Text.escapePath(page.getPath()) + ".thumb." + width + "." + height + ".png?ck=" + ck;
    }
}

