/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.sightly;

import com.adobe.cq.sightly.SightlyWCMMode;
import com.adobe.cq.sightly.WCMResourceOptions;
import com.adobe.cq.sightly.internal.PrintWriterResponseWrapper;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.IncludeOptions;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.scripting.sightly.SightlyException;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class WCMScriptHelper {
    private final Logger log = LoggerFactory.getLogger(WCMScriptHelper.class);
    private SlingScriptHelper slingHelper;
    private SlingHttpServletRequest request;
    private SlingHttpServletResponse response;
    private SightlyWCMMode mode;

    public WCMScriptHelper(SlingScriptHelper sling) {
        this.slingHelper = sling;
        this.request = sling.getRequest();
        this.response = sling.getResponse();
        this.mode = new SightlyWCMMode(this.request);
    }

    public void includeResource(PrintWriter out, String script, String dispatcherOptions, String resourceType, WCMResourceOptions wcmResourceOptions) {
        PrintWriterResponseWrapper customResponse = new PrintWriterResponseWrapper(out, this.response);
        this.includeResource((SlingHttpServletResponse)customResponse, script, dispatcherOptions, resourceType, wcmResourceOptions);
    }

    public void includeResource(SlingHttpServletResponse customResponse, String script, String dispatcherOptions, String resourceType, WCMResourceOptions wcmResourceOptions) {
        this.includeResource(customResponse, script, dispatcherOptions, resourceType, wcmResourceOptions, Collections.EMPTY_MAP);
    }

    public void includeResource(SlingHttpServletResponse response, String script, String dispatcherOptions, String resourceType, WCMResourceOptions wcmResourceOptions, Map<String, Object> resourceProperties) {
        if (StringUtils.isEmpty(script)) {
            this.log.error("Script path cannot be empty.");
        } else {
            Resource includedResource;
            script = this.normalizePath(script);
            ResourceResolver resourceResolver = this.request.getResourceResolver();
            if (resourceProperties != null && resourceProperties.size() > 0) {
                includedResource = new SyntheticResourceWithProperties(resourceResolver, script, resourceType, resourceProperties);
            } else {
                includedResource = resourceResolver.resolve(script);
                if (ResourceUtil.isNonExistingResource(includedResource) && resourceType != null) {
                    includedResource = new SyntheticResource(resourceResolver, script, resourceType);
                }
            }
            this.includeResource(response, includedResource, dispatcherOptions, resourceType, wcmResourceOptions);
        }
    }

    public void includeResource(SlingHttpServletResponse response, Resource resource, String dispatcherOptions, String resourceType, WCMResourceOptions wcmResourceOptions) {
        if (resource == null) {
            this.log.error("Included resource cannot be null.");
        } else {
            WCMMode currentMode = (WCMMode)((Object)this.request.getAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME));
            try {
                WCMMode mode = wcmResourceOptions.getWCMMode();
                if (mode != null) {
                    this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)mode);
                }
                IncludeOptions includeOptions = IncludeOptions.getOptions(this.request, true);
                String decorationTagName = wcmResourceOptions.getDecorationTagName();
                if (StringUtils.isNotEmpty(decorationTagName)) {
                    includeOptions.setDecorationTagName(decorationTagName);
                } else if (!wcmResourceOptions.getDecoration()) {
                    includeOptions.setDecorationTagName("");
                }
                String cssClassName = wcmResourceOptions.getCssClassName();
                if (StringUtils.isNotEmpty(cssClassName)) {
                    includeOptions.getCssClassNames().addAll(this.expandClassName(cssClassName));
                }
                RequestDispatcherOptions requestDispatcherOptions = new RequestDispatcherOptions(dispatcherOptions);
                if (StringUtils.isNotEmpty(resourceType)) {
                    requestDispatcherOptions.setForceResourceType(resourceType);
                }
                RequestDispatcher dispatcher = this.request.getRequestDispatcher(resource, requestDispatcherOptions);
                if (resource.getClass() == SyntheticResource.class) {
                    requestDispatcherOptions.remove("forceResourceType");
                }
                dispatcher.include(this.request, response);
            }
            catch (Exception e) {
                if (e instanceof SightlyException) {
                    throw (SightlyException)e;
                }
                throw new SightlyException(e);
            }
            finally {
                if (currentMode == null) {
                    this.request.removeAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME);
                } else {
                    this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)currentMode);
                }
            }
        }
    }

    public void includeScript(String script, String wcmMode, PrintWriter out) {
        if (StringUtils.isEmpty(script)) {
            this.log.error("Script path cannot be empty.");
        } else {
            ServletResolver servletResolver;
            WCMMode mode;
            WCMMode currentMode = (WCMMode)((Object)this.request.getAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME));
            if (StringUtils.isNotEmpty(wcmMode) && (mode = WCMMode.valueOf(wcmMode.toUpperCase())) != null) {
                this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)mode);
            }
            if ((servletResolver = this.slingHelper.getService(ServletResolver.class)) != null) {
                Servlet servlet = servletResolver.resolveServlet(this.request.getResource(), script);
                if (servlet != null) {
                    try {
                        PrintWriterResponseWrapper resWrapper = new PrintWriterResponseWrapper(out, this.response);
                        servlet.service(this.request, (ServletResponse)resWrapper);
                    }
                    catch (Exception e) {
                        if (e instanceof SightlyException) {
                            throw (SightlyException)e;
                        }
                        throw new SightlyException(e);
                    }
                } else {
                    this.log.error("Failed to locate script {}.", (Object)script);
                }
            } else {
                this.log.error("Sling ServletResolver service is unavailable, failed to include {}.", (Object)script);
            }
            if (currentMode == null) {
                this.request.removeAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME);
            } else {
                this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)currentMode);
            }
        }
    }

    public SightlyWCMMode getMode() {
        return this.mode;
    }

    private String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = this.request.getResource().getPath() + "/" + path;
        }
        return ResourceUtil.normalize(path);
    }

    private List<String> expandClassName(String classesString) {
        String[] classesArray = classesString.split("\\s");
        ArrayList<String> classes = new ArrayList<String>();
        for (String c : classesArray) {
            if (!StringUtils.isNotEmpty(c = c.trim())) continue;
            classes.add(c);
        }
        return classes;
    }

    private static class SyntheticResourceWithProperties
    extends SyntheticResource {
        private Map<String, Object> properties;

        SyntheticResourceWithProperties(ResourceResolver resourceResolver, String path, String resourceType, Map<String, Object> properties) {
            super(resourceResolver, path, resourceType);
            this.properties = properties;
        }

        @Override
        public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
            if (type == ValueMap.class) {
                return (AdapterType)new ValueMapDecorator(this.properties);
            }
            return super.adaptTo(type);
        }
    }
}

