/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.util;

import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.LiveCopy;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import java.util.Optional;
import javax.jcr.RangeIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalizationUtils.class);

    @Nullable
    public static String getLocalizationRoot(@NotNull Resource resource, @NotNull ResourceResolver resolver, @NotNull LanguageManager languageManager, @NotNull LiveRelationshipManager relationshipManager) {
        String root = LocalizationUtils.getLanguageRoot(resource, languageManager);
        if (StringUtils.isEmpty(root)) {
            root = LocalizationUtils.getBlueprintPath(resource, relationshipManager);
        }
        if (StringUtils.isEmpty(root)) {
            root = LocalizationUtils.getLiveCopyPath(resource, relationshipManager);
        }
        return root;
    }

    @Nullable
    public static String getLanguageRoot(@NotNull Resource resource, @NotNull LanguageManager languageManager) {
        return Optional.ofNullable(languageManager.getLanguageRoot(resource)).map(Page::getPath).orElse(null);
    }

    @Nullable
    public static String getBlueprintPath(@NotNull Resource resource, @NotNull LiveRelationshipManager relationshipManager) {
        try {
            LiveRelationship relationship;
            LiveCopy liveCopy;
            RangeIterator liveCopiesIterator;
            if (relationshipManager.isSource(resource) && (liveCopiesIterator = relationshipManager.getLiveRelationships(resource, null, null)) != null && (liveCopy = (relationship = (LiveRelationship)liveCopiesIterator.next()).getLiveCopy()) != null) {
                return liveCopy.getBlueprintPath();
            }
        }
        catch (WCMException e) {
            LOGGER.error("Unable to get the blueprint: {}", (Object)e.getMessage());
        }
        return null;
    }

    @Nullable
    public static String getLiveCopyPath(@NotNull Resource resource, @NotNull LiveRelationshipManager relationshipManager) {
        try {
            LiveCopy liveCopy;
            LiveRelationship liveRelationship;
            if (relationshipManager.hasLiveRelationship(resource) && (liveRelationship = relationshipManager.getLiveRelationship(resource, false)) != null && (liveCopy = liveRelationship.getLiveCopy()) != null) {
                return liveCopy.getPath();
            }
        }
        catch (WCMException e) {
            LOGGER.error("Unable to get the live copy: {}", (Object)e.getMessage());
        }
        return null;
    }
}

