/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;

final class HmtxRaw
extends Table {
    protected HmtxRaw(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
    }

    public int getLeftSideBearing(int glyphID, int numberOfHMetrics) throws InvalidFontException {
        if (glyphID < numberOfHMetrics) {
            return this.data.getint16(4 * glyphID + 2);
        }
        return this.data.getint16(4 * numberOfHMetrics + 2 * (glyphID - numberOfHMetrics));
    }

    public int getHorizontalAdvance(int glyphID, int numberOfHMetrics) throws InvalidFontException {
        if (glyphID < numberOfHMetrics) {
            return this.data.getuint16(4 * glyphID);
        }
        return this.data.getuint16(4 * (numberOfHMetrics - 1));
    }
}

