/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.fxg;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.IntelligentResolver;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontResolver;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontSearchAttributes;
import java.util.HashMap;

public class FXGFontResolverImpl
implements FXGFontResolver {
    private HashMap fxgFonts;
    private FontResolutionPriority resolutionPriority = FontResolutionPriority.FIRST;
    private static final long serialVersionUID = 1L;

    public FXGFontResolverImpl() {
        this.fxgFonts = new HashMap();
    }

    public FXGFontResolverImpl(FXGFontResolverImpl original) {
        this.fxgFonts = (HashMap)original.fxgFonts.clone();
        this.resolutionPriority = original.resolutionPriority;
    }

    @Override
    public void addFont(Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        FXGFontDescription[] fxgDesc = font.getFXGFontDescription();
        for (int i = 0; i < fxgDesc.length; ++i) {
            this.addFont(fxgDesc[i], font);
        }
    }

    @Override
    public void addFont(FXGFontDescription fxgDesc, Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        FXGKey searchKey = new FXGKey(fxgDesc);
        FXGValue oldValue = (FXGValue)this.fxgFonts.get(searchKey);
        if (oldValue != null) {
            Font preferredFont;
            Font oldFont = oldValue.getFont();
            if (this.resolutionPriority == FontResolutionPriority.FIRST) {
                return;
            }
            if ((this.resolutionPriority == FontResolutionPriority.INTELLIGENT_LAST || this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST) && (preferredFont = IntelligentResolver.choosePreferredFont(oldFont, font, this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST)) == oldFont) {
                return;
            }
        }
        this.fxgFonts.put(searchKey, new FXGValue(fxgDesc, font));
    }

    @Override
    public Font findFont(FXGFontSearchAttributes searchAttributes) {
        FXGValue value = (FXGValue)this.fxgFonts.get(new FXGKey(searchAttributes));
        if (value == null) {
            return null;
        }
        return value.getFont();
    }

    @Override
    public boolean isEmpty() {
        return this.fxgFonts.isEmpty();
    }

    @Override
    public FontResolutionPriority setResolutionPriority(FontResolutionPriority priority) {
        FontResolutionPriority oldPriority = this.resolutionPriority;
        this.resolutionPriority = priority;
        return oldPriority;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fxgFonts == null ? 0 : this.fxgFonts.hashCode());
        result = 31 * result + (this.resolutionPriority == null ? 0 : this.resolutionPriority.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FXGFontResolverImpl)) {
            return false;
        }
        FXGFontResolverImpl other = (FXGFontResolverImpl)obj;
        if (this.fxgFonts == null ? other.fxgFonts != null : !this.fxgFonts.equals(other.fxgFonts)) {
            return false;
        }
        return !(this.resolutionPriority == null ? other.resolutionPriority != null : !this.resolutionPriority.equals(other.resolutionPriority));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FXG Fonts:\n");
        for (FXGKey k : this.fxgFonts.keySet()) {
            sb.append("  ");
            sb.append(k);
            sb.append(" = ");
            sb.append(((FXGValue)this.fxgFonts.get(k)).getFont().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static final class FXGValue {
        private final FXGFontDescription fxgDescription;
        private final Font font;

        FXGValue(FXGFontDescription fxgDescription, Font font) {
            this.fxgDescription = fxgDescription;
            this.font = font;
        }

        FXGFontDescription getFXGDescription() {
            return this.fxgDescription;
        }

        Font getFont() {
            return this.font;
        }

        public String toString() {
            return new String(this.fxgDescription.toString() + "\n\t" + this.font.toString());
        }
    }

    private static final class FXGKey {
        private final String familyName;
        private final boolean isBold;
        private final boolean isItalic;

        protected FXGKey(FXGFontDescription fxgDescription) {
            this.familyName = fxgDescription.getFamilyName();
            this.isBold = fxgDescription.isBold();
            this.isItalic = fxgDescription.isItalic();
        }

        protected FXGKey(FXGFontSearchAttributes fxgSearchAttributes) {
            this.familyName = fxgSearchAttributes.getFamilyName();
            this.isBold = fxgSearchAttributes.isBold();
            this.isItalic = fxgSearchAttributes.isItalic();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.familyName == null ? 0 : this.familyName.hashCode());
            result = 31 * result + (this.isBold ? 1231 : 1237);
            result = 31 * result + (this.isItalic ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FXGKey)) {
                return false;
            }
            FXGKey other = (FXGKey)obj;
            if (this.familyName == null ? other.familyName != null : !this.familyName.equals(other.familyName)) {
                return false;
            }
            if (this.isBold != other.isBold) {
                return false;
            }
            return this.isItalic == other.isItalic;
        }

        public String toString() {
            return new String(this.familyName + (this.isBold ? ", bold" : "") + (this.isItalic ? ", italic" : ""));
        }
    }
}

