/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.css20;

import com.adobe.fontengine.font.FontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;

public final class CSS20FontDescription
extends FontDescription {
    static final long serialVersionUID = 1L;
    private final String familyName;
    private final CSS20Attribute.CSSStyleValue style;
    private final CSS20Attribute.CSSVariantValue variant;
    private final CSS20Attribute.CSSStretchValue stretch;
    private final int weight;
    private final double lowPointSize;
    private final double highPointSize;

    public CSS20FontDescription(String familyName, CSS20Attribute.CSSStyleValue style, CSS20Attribute.CSSVariantValue variant, CSS20Attribute.CSSStretchValue stretch, int weight, double lowPointSize, double highPointSize) {
        this.familyName = familyName;
        this.style = style;
        this.variant = variant;
        this.stretch = stretch;
        this.weight = weight;
        this.lowPointSize = lowPointSize;
        this.highPointSize = highPointSize;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public CSS20Attribute.CSSStyleValue getStyle() {
        return this.style;
    }

    public CSS20Attribute.CSSVariantValue getVariant() {
        return this.variant;
    }

    public int getWeight() {
        return this.weight;
    }

    public CSS20Attribute.CSSStretchValue getStretch() {
        return this.stretch;
    }

    public double getLowPointSize() {
        return this.lowPointSize;
    }

    public double getHighPointSize() {
        return this.highPointSize;
    }

    public int hashCode() {
        int hash = this.familyName.hashCode() ^ this.style.hashCode() ^ this.variant.hashCode() ^ this.stretch.hashCode() ^ this.weight ^ (int)(this.lowPointSize * 100.0) ^ (int)(this.highPointSize * 100.0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CSS20FontDescription && this.familyName.equals(((CSS20FontDescription)obj).familyName) && this.style.equals(((CSS20FontDescription)obj).style) && this.variant.equals(((CSS20FontDescription)obj).variant) && this.stretch.equals(((CSS20FontDescription)obj).stretch) && this.weight == ((CSS20FontDescription)obj).weight && this.lowPointSize == ((CSS20FontDescription)obj).lowPointSize && this.highPointSize == ((CSS20FontDescription)obj).highPointSize) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer description = new StringBuffer();
        description.append("{familyName = " + this.familyName + ", ");
        if (this.style == CSS20Attribute.CSSStyleValue.NORMAL) {
            description.append("stl = NORMAL, ");
        } else if (this.style == CSS20Attribute.CSSStyleValue.ITALIC) {
            description.append("stl = ITALIC, ");
        } else if (this.style == CSS20Attribute.CSSStyleValue.OBLIQUE) {
            description.append("stl = OBLIQUE, ");
        }
        if (this.variant == CSS20Attribute.CSSVariantValue.NORMAL) {
            description.append("var = NORMAL, ");
        } else if (this.variant == CSS20Attribute.CSSVariantValue.SMALL_CAPS) {
            description.append("var = SMALL-CAPS, ");
        }
        description.append("wt = " + this.weight + ", ");
        description.append("str = " + this.stretch.toString() + ", ");
        description.append("lowPt = " + this.lowPointSize + ", ");
        description.append("highPt = " + this.highPointSize + "}");
        return description.toString();
    }
}

