/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.rest.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class DeepModifiableValueMapDecorator
extends ModifiableValueMapDecorator {
    protected final String pathPrefix;
    protected final ResourceResolver resolver;
    protected final Map<String, Object> base;
    protected final String[] subnodes;

    public DeepModifiableValueMapDecorator(Resource resource, Map<String, Object> base, String[] subnodes) {
        super(base);
        this.pathPrefix = resource.getPath() + "/";
        this.resolver = resource.getResourceResolver();
        this.base = base;
        this.subnodes = subnodes;
    }

    public DeepModifiableValueMapDecorator(Resource resource, Map<String, Object> base) {
        this(resource, base, new String[0]);
    }

    protected ValueMap getValueMap(String name) {
        int pos = name.lastIndexOf("/");
        if (pos == -1) {
            return new ModifiableValueMapDecorator(this.base);
        }
        Resource rsrc = this.resolver.getResource(this.pathPrefix + name.substring(0, pos));
        if (rsrc != null) {
            ValueMap vm = rsrc.adaptTo(ModifiableValueMap.class);
            if (vm == null) {
                vm = rsrc.adaptTo(ValueMap.class);
            }
            if (vm != null) {
                return new ModifiableValueMapDecorator(vm);
            }
        }
        return ModifiableValueMap.EMPTY;
    }

    protected String getPropertyName(String name) {
        int pos = name.lastIndexOf("/");
        if (pos == -1) {
            return name;
        }
        return name.substring(pos + 1);
    }

    @Override
    public <T> T get(String name, Class<T> type) {
        return (T)this.getValueMap(name).get(this.getPropertyName(name), type);
    }

    @Override
    public <T> T get(String name, T defaultValue) {
        return this.getValueMap(name).get(this.getPropertyName(name), defaultValue);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        String name = key.toString();
        return this.getValueMap(name).containsKey(this.getPropertyName(name));
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        String name = key.toString();
        if (ArrayUtils.contains(this.subnodes, name)) {
            return this.getValueMap(name + "/");
        }
        return this.getValueMap(name).get(this.getPropertyName(name));
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            return null;
        }
        String name = key.toString();
        if (name.indexOf("/") > -1) {
            String subnode = name.substring(0, name.indexOf("/"));
            if (ArrayUtils.contains(this.subnodes, subnode)) {
                return this.getValueMap(name).put(this.getPropertyName(name), value);
            }
            return null;
        }
        return this.getValueMap(name).put(this.getPropertyName(name), value);
    }

    @Override
    public void putAll(Map<? extends String, ?> t) {
        for (String string : t.keySet()) {
            this.put(string, t.get(string));
        }
    }

    @Override
    public Set<String> keySet() {
        return this.buildAggregatedMap().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.buildAggregatedMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.buildAggregatedMap().entrySet();
    }

    private ValueMap buildAggregatedMap() {
        ValueMapDecorator entries = new ValueMapDecorator(new HashMap<String, Object>());
        for (Map.Entry entry : this.getValueMap("").entrySet()) {
            entries.put(entry.getKey(), entry.getValue());
        }
        for (String subnode : this.subnodes) {
            entries.put(subnode, this.getValueMap(subnode + "/"));
        }
        return entries;
    }
}

