/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.Field;
import com.adobe.granite.ui.components.ValueFetchStrategy;
import com.adobe.granite.ui.components.impl.ValueMapValueFetchStrategy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class BulkEditValueMap
implements ValueMap {
    private List<Resource> resources;
    private Map<String, MergedValue> cache;
    private Map<String, ValueFetchStrategy> fetchStrategies;

    public BulkEditValueMap(@Nonnull List<Resource> resources) {
        this(resources, Collections.emptyMap());
    }

    public BulkEditValueMap(@Nonnull List<Resource> resources, @Nonnull Map<String, ValueFetchStrategy> fetchStrategies) {
        this.resources = resources;
        this.cache = new HashMap<String, MergedValue>();
        this.fetchStrategies = fetchStrategies;
    }

    @Override
    public Object get(Object key) {
        String keyName = (String)key;
        MergedValue mergedValue = this.fetchMergedValue(keyName);
        return keyName.endsWith(Field.IS_MIXED_SUFFIX) ? Boolean.valueOf(mergedValue.isMixed()) : mergedValue.getValue();
    }

    @Override
    public <T> T get(@Nonnull String name, @Nonnull Class<T> type) {
        Object value = this.get(name);
        return (T)(type == null ? value : this.convert(value, type));
    }

    @Override
    @Nonnull
    public <T> T get(@Nonnull String name, @Nonnull T defaultValue) {
        Class<?> value = this.get(name, (T)(defaultValue != null ? defaultValue.getClass() : null));
        return (T)(value == null ? defaultValue : value);
    }

    @Nonnull
    private MergedValue fetchMergedValue(@Nonnull String key) {
        MergedValue mergedValue;
        if (key.endsWith(Field.IS_MIXED_SUFFIX)) {
            key = key.replace(Field.IS_MIXED_SUFFIX, "");
        }
        if (this.cache.containsKey(key)) {
            mergedValue = this.cache.get(key);
        } else {
            Object strategy = this.fetchStrategies.containsKey(key) ? this.fetchStrategies.get(key) : new ValueMapValueFetchStrategy();
            List<Object> values = this.fetchValues(key, (ValueFetchStrategy)strategy);
            mergedValue = values.size() == 0 ? new MergedValue(null, false) : (values.size() < this.resources.size() ? new MergedValue(null, true) : new MergedValue(values));
            this.cache.put(key, mergedValue);
        }
        return mergedValue;
    }

    @Nonnull
    private List<Object> fetchValues(@Nonnull String key, @Nonnull ValueFetchStrategy fetchStrategy) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Resource resource : this.resources) {
            Object value = fetchStrategy.apply(key, resource);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Set<String> keySet() {
        return null;
    }

    @Override
    public Collection<Object> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @CheckForNull
    private <T> T convert(@CheckForNull Object obj, @Nonnull Class<T> type) {
        try {
            if (obj == null) {
                return null;
            }
            if (type.isAssignableFrom(obj.getClass())) {
                return (T)obj;
            }
            if (type.isArray()) {
                return (T)this.convertToArray(obj, type.getComponentType());
            }
            if (obj instanceof String && type == Calendar.class) {
                return (T)ISO8601.parse(obj.toString());
            }
            if (obj instanceof Calendar && type == String.class) {
                return (T)ISO8601.format((Calendar)obj);
            }
            if (type == String.class) {
                return (T)String.valueOf(obj);
            }
            if (type == Integer.class) {
                return (T)Integer.valueOf(Integer.parseInt(obj.toString()));
            }
            if (type == Long.class) {
                return (T)Long.valueOf(Long.parseLong(obj.toString()));
            }
            if (type == Double.class) {
                return (T)Double.valueOf(Double.parseDouble(obj.toString()));
            }
            if (type == Boolean.class) {
                return (T)("".equals(obj.toString()) ? null : Boolean.valueOf(Boolean.parseBoolean(obj.toString())));
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    private <T> T[] convertToArray(@Nonnull Object obj, @Nonnull Class<T> type) {
        LinkedList<T> values = new LinkedList<T>();
        if (obj.getClass().isArray()) {
            for (Object o : (Object[])obj) {
                values.add(this.convert(o, type));
            }
        } else {
            values.add(this.convert(obj, type));
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    private class MergedValue {
        private Object value;
        private boolean isMixed;
        private static final String MIXED_VALUE = "";

        public MergedValue(Object value, boolean isMixed) {
            this.value = value;
            this.isMixed = isMixed;
        }

        public MergedValue(List<Object> values) {
            if (values.get(0).getClass().isArray()) {
                this.doMergeArrayValues(values);
            } else {
                this.doMergeSingleValues(values);
            }
        }

        private void doMergeSingleValues(@Nonnull List<Object> values) {
            Object mergedValue;
            boolean isMixed;
            HashSet<Object> set = new HashSet<Object>(values);
            ArrayList<Object> uniqueValues = new ArrayList<Object>(set);
            if (uniqueValues.size() == 1) {
                isMixed = false;
                mergedValue = values.get(0);
            } else {
                isMixed = true;
                mergedValue = MIXED_VALUE;
            }
            this.isMixed = isMixed;
            this.value = mergedValue;
        }

        private boolean equalsIgnoreOrder(@Nonnull Object[] first, @Nonnull Object[] second) {
            HashSet<Object> firstSet = new HashSet<Object>(Arrays.asList(first));
            HashSet<Object> secondSet = new HashSet<Object>(Arrays.asList(second));
            return firstSet.equals(secondSet);
        }

        private void doMergeArrayValues(@Nonnull List<Object> arrayValues) {
            boolean isMixed = false;
            Object[] previousMerge = null;
            Object[] previousValue = null;
            for (Object arrayValue : arrayValues) {
                Object[] currentValue = (Object[])arrayValue;
                if (previousValue == null) {
                    previousValue = currentValue;
                    previousMerge = currentValue;
                    continue;
                }
                Object[] currentMerge = CollectionUtils.intersection(Arrays.asList(previousMerge), Arrays.asList(currentValue)).toArray();
                if (!this.equalsIgnoreOrder(previousValue, currentValue)) {
                    isMixed = true;
                }
                previousValue = currentValue;
                previousMerge = currentMerge;
            }
            Object[] mergedValue = previousMerge;
            this.isMixed = isMixed;
            this.value = mergedValue;
        }

        @CheckForNull
        public Object getValue() {
            return this.value;
        }

        public boolean isMixed() {
            return this.isMixed;
        }
    }
}

