/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosParseBuf;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosToken;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.StringOps;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;

public class CosObjectStream
extends CosStream {
    private CosList mNewObjList;
    private int[] mNewObjNumbers;
    private int[] mNewObjOffsets;
    private int[] mOldObjNumbers;
    private int[] mOldObjOffsets;
    private Object mOldDataStream;

    CosObjectStream(CosDocument doc) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        super(doc, doc.newObjectInfo());
        this.put(ASName.k_Type, ASName.k_ObjStm);
        this.getInfo().setIsObjStm(true);
    }

    CosObjectStream(CosDocument doc, Map map, CosObjectInfo info, long pos) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        super(doc, map, info, pos);
        int numObjects = this.get(ASName.k_N).intValue();
        int objBase = this.get(ASName.k_First).intValue();
        InputByteStream stmData = this.getDataStream();
        stmData.seek(0L);
        CosParseBuf pBuf = new CosParseBuf(stmData, objBase);
        this.mOldObjNumbers = new int[numObjects];
        this.mOldObjOffsets = new int[numObjects];
        for (int objNdx = 0; objNdx < numObjects; ++objNdx) {
            this.mOldObjNumbers[objNdx] = CosToken.readNumber(pBuf, CosToken.skipWhitespace(pBuf)).intValue();
            int offset = CosToken.readNumber(pBuf, CosToken.skipWhitespace(pBuf)).intValue();
            this.mOldObjOffsets[objNdx] = objBase + offset;
        }
        info.setIsObjStm(true);
    }

    InputByteStream getBytesForObject(int objNum) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        for (int i = 0; i < this.mOldObjNumbers.length; ++i) {
            if (this.mOldObjNumbers[i] != objNum) continue;
            InputByteStream stm = this.getDataStream();
            stm.seek(this.mOldObjOffsets[i]);
            int objLen = 0;
            objLen = i == this.mOldObjNumbers.length - 1 ? (int)stm.length() : this.mOldObjOffsets[i + 1];
            return new CosParseBuf(stm, (objLen -= this.mOldObjOffsets[i]) + 1, true);
        }
        return null;
    }

    InputByteStream getDataStream() throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        if (this.mOldDataStream instanceof InputByteStream) {
            return (InputByteStream)this.mOldDataStream;
        }
        InputByteStream dataStream = null;
        if (this.mOldDataStream instanceof SoftReference) {
            dataStream = (InputByteStream)((SoftReference)this.mOldDataStream).get();
        }
        if (dataStream == null) {
            dataStream = this.getStream(false, false, false);
            this.mOldDataStream = new SoftReference<InputByteStream>(dataStream);
        }
        return dataStream;
    }

    void addObjectToStream(CosObject obj) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        this.getInfo().markDirty();
        if (this.mNewObjList == null) {
            this.mNewObjList = new CosList();
        }
        this.mNewObjList.add(obj.getInfo());
    }

    void setObjectStreamList(CosList objectList) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        this.getInfo().markDirty();
        this.mNewObjList = objectList;
    }

    void update() {
        if (this.mNewObjList != null) {
            this.mOldObjNumbers = this.mNewObjNumbers;
            this.mOldObjOffsets = this.mNewObjOffsets;
            this.reset();
        }
    }

    void reset() {
        this.mNewObjList = null;
        this.mNewObjNumbers = null;
        this.mNewObjOffsets = null;
        this.mOldDataStream = null;
    }

    void writeObjectsToStream() throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (this.mNewObjList == null || this.mNewObjList.isEmpty()) {
            return;
        }
        int numObjects = 0;
        int[] objNumbers = new int[this.mNewObjList.count()];
        int[] objOffsets = new int[this.mNewObjList.count()];
        OutputByteStream objos = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
        Iterator<Object> iterator = this.mNewObjList.iterator();
        while (iterator.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)iterator.next();
            CosObject obj = info.getObject();
            info.setPos(objos.getPosition());
            info.setObjGen(0);
            objNumbers[numObjects] = info.getObjNum();
            objOffsets[numObjects] = (int)info.getPos();
            info.setWriteCompressed(true);
            obj.writeOut(objos);
            objos.write(32);
            info.setStreamInfo(this.getInfo());
            info.setStreamNdx(numObjects);
            ++numObjects;
        }
        OutputByteStream os = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
        Iterator<Object> iter = this.mNewObjList.iterator();
        while (iter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)iter.next();
            os.write(StringOps.toByteArray(Integer.toString(info.getObjNum())));
            os.write(32);
            os.write(StringOps.toByteArray(Long.toString(info.getPos())));
            os.write(32);
        }
        long objBase = os.getPosition();
        this.put(ASName.k_First, (int)objBase);
        int i = 0;
        while (i < numObjects) {
            int n = i++;
            objOffsets[n] = (int)((long)objOffsets[n] + objBase);
        }
        this.put(ASName.k_N, numObjects);
        InputByteStream objis = objos.closeAndConvert();
        objos = null;
        IO.copy(objis, os);
        objis.close();
        objis = null;
        this.mOldDataStream = this.getDataStream();
        this.newDataDecoded(os.closeAndConvert());
        os = null;
        this.mNewObjNumbers = objNumbers;
        this.mNewObjOffsets = objOffsets;
        this.put(ASName.k_Filter, ASName.k_FlateDecode);
    }
}

