/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.util;

import java.util.Comparator;

public final class QuickSort2 {
    private static final int CUTOFF = 8;
    private static final int STKSIZ = 30;

    public static void sort_acro6(Object[] array, Comparator comparator) {
        int[] lostk = new int[30];
        int[] histk = new int[30];
        if (array.length < 2) {
            return;
        }
        int stkptr = 0;
        int lo = 0;
        int hi = array.length - 1;
        while (true) {
            int size;
            if ((size = hi - lo + 1) <= 8) {
                QuickSort2.shortsort(array, lo, hi, comparator);
            } else {
                int mid = lo + size / 2;
                QuickSort2.swap(array, mid, lo);
                int loguy = lo;
                int higuy = hi + 1;
                while (true) {
                    if (++loguy <= hi && comparator.compare(array[loguy], array[lo]) <= 0) {
                        continue;
                    }
                    while (--higuy > lo && comparator.compare(array[higuy], array[lo]) >= 0) {
                    }
                    if (higuy < loguy) break;
                    QuickSort2.swap(array, loguy, higuy);
                }
                QuickSort2.swap(array, lo, higuy);
                if (higuy - 1 - lo >= hi - loguy) {
                    if (lo + 1 < higuy) {
                        lostk[stkptr] = lo;
                        histk[stkptr] = higuy - 1;
                        ++stkptr;
                    }
                    if (loguy < hi) {
                        lo = loguy;
                        continue;
                    }
                } else {
                    if (loguy < hi) {
                        lostk[stkptr] = loguy;
                        histk[stkptr] = hi;
                        ++stkptr;
                    }
                    if (lo + 1 < higuy) {
                        hi = higuy - 1;
                        continue;
                    }
                }
            }
            if (--stkptr < 0) break;
            lo = lostk[stkptr];
            hi = histk[stkptr];
        }
    }

    static void shortsort(Object[] array, int lo, int hi, Comparator comparator) {
        while (hi > lo) {
            int max = lo;
            for (int i = lo + 1; i <= hi; ++i) {
                if (comparator.compare(array[i], array[max]) <= 0) continue;
                max = i;
            }
            QuickSort2.swap(array, max, hi);
            --hi;
        }
    }

    static void swap(Object[] array, int i, int j) {
        if (i != j) {
            Object temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }
}

