/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArrayMap
implements Map {
    private ArrayList mKeys;
    private ArrayList mValues;
    private HashMap mKeysMapping;
    private int mCurIndex;

    public ArrayMap(int size) {
        this.mKeys = new ArrayList(size);
        this.mValues = new ArrayList(size);
        this.mKeysMapping = new HashMap(size * 2);
        this.mCurIndex = 0;
    }

    public ArrayMap() {
        this(100);
    }

    public int size() {
        return this.mCurIndex;
    }

    public void clear() {
        this.mCurIndex = 0;
        this.mKeys.clear();
        this.mValues.clear();
        this.mKeysMapping.clear();
    }

    public boolean isEmpty() {
        return this.mCurIndex == 0;
    }

    public boolean containsKey(Object arg0) {
        return this.mKeysMapping.containsKey(arg0);
    }

    public boolean containsValue(Object arg0) {
        return this.mValues.contains(arg0);
    }

    public Collection values() {
        return this.mValues;
    }

    public void putAll(Map arg0) {
        for (Map.Entry curEntry : arg0.entrySet()) {
            this.put(curEntry.getKey(), curEntry.getValue());
        }
    }

    public Set entrySet() {
        return new ArrayEntrySet();
    }

    public Set keySet() {
        return new ArrayKeySet();
    }

    public Object get(Object arg0) {
        Integer pos = (Integer)this.mKeysMapping.get(arg0);
        if (pos == null) {
            return null;
        }
        return this.mValues.get(pos);
    }

    public Object remove(Object arg0) {
        Integer pos = (Integer)this.mKeysMapping.get(arg0);
        if (pos == null) {
            return null;
        }
        Object oldValue = this.mValues.get(pos);
        this.mKeysMapping.remove(arg0);
        this.mKeys.remove(pos);
        this.mValues.remove(pos);
        --this.mCurIndex;
        for (int mapInd = pos.intValue(); mapInd < this.mCurIndex; ++mapInd) {
            this.mKeysMapping.put(this.mKeys.get(mapInd), mapInd);
        }
        return oldValue;
    }

    public Object put(Object arg0, Object arg1) {
        Integer pos = (Integer)this.mKeysMapping.get(arg0);
        Object oldValue = null;
        if (pos != null) {
            oldValue = this.mValues.get(pos);
            this.mValues.set(pos, arg1);
        } else {
            Integer key = this.mCurIndex;
            this.mKeysMapping.put(arg0, key);
            this.mKeys.add(this.mCurIndex, arg0);
            this.mValues.add(this.mCurIndex++, arg1);
        }
        return oldValue;
    }

    private class ArrayEntrySet
    implements Set {
        ArrayEntrySet() {
        }

        public int size() {
            return ArrayMap.this.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return ArrayMap.this.isEmpty();
        }

        public Object[] toArray() {
            Object[] entries = new Object[ArrayMap.this.size()];
            for (int posInd = 0; posInd < ArrayMap.this.size(); ++posInd) {
                entries[posInd] = new Entry(posInd);
            }
            return entries;
        }

        public boolean add(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object arg0) {
            if (!(arg0 instanceof Entry)) {
                return false;
            }
            Object entryKey = ((Entry)arg0).getKey();
            Object mapKey = ArrayMap.this.get(entryKey);
            if (mapKey == null) {
                return false;
            }
            return ArrayMap.this.get(mapKey).equals(((Entry)arg0).getValue());
        }

        public boolean remove(Object arg0) {
            if (!(arg0 instanceof Entry)) {
                return false;
            }
            Object key = ((Entry)arg0).getKey();
            if (!ArrayMap.this.containsKey(key)) {
                return false;
            }
            ArrayMap.this.remove(arg0);
            return true;
        }

        public boolean addAll(Collection arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection arg0) {
            if (arg0 == null) {
                return false;
            }
            Iterator entryIterator = arg0.iterator();
            while (entryIterator.hasNext()) {
                if (this.contains(entryIterator.next())) continue;
                return false;
            }
            return true;
        }

        public boolean removeAll(Collection arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection arg0) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public Object[] toArray(Object[] arg0) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    implements Iterator {
        int mPos = 0;

        EntryIterator() {
        }

        public boolean hasNext() {
            return this.mPos < ArrayMap.this.size();
        }

        public Object next() {
            return new Entry(this.mPos++);
        }

        public void remove() {
            if (this.mPos < 1) {
                throw new IllegalStateException();
            }
            Entry curEntry = new Entry(--this.mPos);
            Object key = curEntry.getKey();
            ArrayMap.this.remove(key);
        }
    }

    private class KeyIterator
    implements Iterator {
        int mPos = 0;

        KeyIterator() {
        }

        public boolean hasNext() {
            return this.mPos < ArrayMap.this.size();
        }

        public Object next() {
            return ArrayMap.this.mKeys.get(this.mPos++);
        }

        public void remove() {
            if (this.mPos < 1) {
                throw new IllegalStateException();
            }
            Object key = ArrayMap.this.mKeys.get(--this.mPos);
            ArrayMap.this.remove(key);
        }
    }

    private class ArrayKeySet
    implements Set {
        ArrayKeySet() {
        }

        public int size() {
            return ArrayMap.this.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return ArrayMap.this.isEmpty();
        }

        public Object[] toArray() {
            return ArrayMap.this.mKeys.toArray();
        }

        public boolean add(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object arg0) {
            return ArrayMap.this.containsKey(arg0);
        }

        public boolean remove(Object arg0) {
            if (!ArrayMap.this.containsKey(arg0)) {
                return false;
            }
            ArrayMap.this.remove(arg0);
            return true;
        }

        public boolean addAll(Collection arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection arg0) {
            return ArrayMap.this.mKeys.containsAll(arg0);
        }

        public boolean removeAll(Collection arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection arg0) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public Object[] toArray(Object[] arg0) {
            return ArrayMap.this.mKeys.toArray(arg0);
        }
    }

    public class Entry
    implements Map.Entry {
        int mMapPos;
        Object mKey;
        Object mValue;

        Entry(int pos) {
            this.mMapPos = pos;
            this.mKey = ArrayMap.this.mKeys.get(this.mMapPos);
            this.mValue = ArrayMap.this.mValues.get(this.mMapPos);
        }

        public Object getKey() {
            return this.mKey;
        }

        public Object getValue() {
            return this.mValue;
        }

        public Object setValue(Object arg0) {
            Object oldValue = this.mValue;
            this.mValue = arg0;
            if (ArrayMap.this.containsKey(this.mKey)) {
                ArrayMap.this.put(this.mKey, arg0);
            }
            return oldValue;
        }
    }
}

