/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.gfx;

import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.gfx.GFXGraphicContext;

public class GFXAttr {
    public static final int STYLE_UNKNOWN = 0;
    public static final int STYLE_NONE = 1;
    public static final int STYLE_SOLID = 2;
    public static final int STYLE_HORZ = 3;
    public static final int STYLE_VERT = 4;
    public static final int STYLE_CROSS = 5;
    public static final int STYLE_DIAG_LEFT = 6;
    public static final int STYLE_DIAG_RIGHT = 7;
    public static final int STYLE_DIAG_CROSS = 8;
    public static final int STYLE_DOT = 9;
    public static final int STYLE_DASH = 10;
    public static final int STYLE_DOT_DASH = 11;
    public static final int STYLE_DOT_DOT_DASH = 12;
    public static final int DEFAULT_SHADESCALE = 100;
    private int mnStyle;
    private int mnShadeScale;
    private int mnShade;
    private GFXColour mpoColour;
    private GFXColour mpoColourBg;
    private GFXGraphicContext mpoContext;

    public GFXAttr() {
        this.initialize();
    }

    public GFXAttr(GFXAttr oSource) {
        this.initialize();
        this.copyFrom(oSource);
    }

    public GFXAttr(int nNewStyle, int lNewShade, GFXColour oNewColour, GFXColour oNewColourBg) {
        this.mnStyle = nNewStyle;
        this.mnShadeScale = 100;
        this.shade(lNewShade);
        this.colour(oNewColour);
        this.colourBg(oNewColourBg);
    }

    public GFXColour colour() {
        return this.mpoColour;
    }

    public void colour(GFXColour oNewColour) {
        int fg = GFXColour.getStandardColourIndex(oNewColour);
        this.mpoColour = fg == 5 ? oNewColour : GFXColour.getStandardColour(fg);
    }

    public GFXColour colourBg() {
        return this.mpoColourBg;
    }

    public void colourBg(GFXColour oNewColourBg) {
        int bg = GFXColour.getStandardColourIndex(oNewColourBg);
        this.mpoColourBg = bg == 5 ? oNewColourBg : GFXColour.getStandardColour(bg);
    }

    public int shade() {
        return this.mnShade;
    }

    public void shade(int lNewShade) {
        this.mnShade = lNewShade < 0 ? 0 : (lNewShade > this.mnShadeScale ? this.mnShadeScale : lNewShade);
    }

    public int shadeScale() {
        return this.mnShadeScale;
    }

    public void shadeScale(int lNewScale) {
        double dOldShadeScale = this.mnShadeScale;
        double dShade = this.mnShade;
        if (lNewScale > 0) {
            this.mnShadeScale = lNewScale;
            double dFactor = dShade / dOldShadeScale;
            this.mnShade = (int)Math.round(dFactor * (double)this.mnShadeScale);
        }
    }

    public GFXColour shadeColour() {
        double dShade = (double)this.mnShade / (double)this.mnShadeScale;
        return GFXColour.weightedAverage(this.colourBg(), this.colour(), dShade);
    }

    public static int defaultShadeScale() {
        return 100;
    }

    public int style() {
        return this.mnStyle;
    }

    public void style(int nNewStyle) {
        this.mnStyle = nNewStyle;
    }

    public GFXGraphicContext graphicContext() {
        return this.mpoContext;
    }

    public void graphicContext(GFXGraphicContext poGraphicContext) {
        this.mpoContext = poGraphicContext;
    }

    public boolean equivalent(GFXAttr oCompare) {
        return this.mnStyle == oCompare.mnStyle && this.mnShadeScale == oCompare.mnShadeScale && this.mnShade == oCompare.mnShade && GFXGraphicContext.match(this.mpoContext, oCompare.mpoContext) && this.mpoColour.equals(oCompare.mpoColour) && this.mpoColourBg.equals(oCompare.mpoColourBg);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.equivalent((GFXAttr)object);
    }

    public int hashCode() {
        int hash = 73;
        hash = hash * 31 ^ this.mnStyle;
        hash = hash * 31 ^ this.mnShadeScale;
        hash = hash * 31 ^ this.mnShade;
        hash = hash * 31 ^ this.mpoColour.hashCode();
        hash = hash * 31 ^ this.mpoColourBg.hashCode();
        hash = hash * 31 ^ this.mpoContext.hashCode();
        return hash;
    }

    public void copyFrom(GFXAttr oSource) {
        if (this != oSource) {
            this.mnStyle = oSource.mnStyle;
            this.mnShadeScale = oSource.mnShadeScale;
            this.mnShade = oSource.mnShade;
            this.mpoColour = oSource.mpoColour;
            this.mpoColourBg = oSource.mpoColourBg;
            this.mpoContext = oSource.mpoContext;
        }
    }

    private void initialize() {
        this.mnStyle = 2;
        this.mnShadeScale = 100;
        this.mnShade = 100;
        this.mpoColour = GFXColour.BLACK;
        this.mpoColourBg = GFXColour.WHITE;
        this.mpoContext = null;
    }
}

