/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.gfx;

public class GFXColour {
    public static final int JF_GFXCOLOUR_DEF_SCALE = 255;
    public static final int BLACK_INDEX = 0;
    public static final int WHITE_INDEX = 1;
    public static final int LIGHTGRAY_INDEX = 2;
    public static final int GRAY_INDEX = 3;
    public static final int DARKGRAY_INDEX = 4;
    public static final int OTHER_INDEX = 5;
    public static final GFXColour BLACK = new GFXColour(0, 0, 0);
    public static final GFXColour WHITE = new GFXColour(255, 255, 255);
    public static final GFXColour LIGHTGRAY = new GFXColour(192, 192, 192);
    public static final GFXColour GRAY = new GFXColour(128, 128, 128);
    public static final GFXColour DARKGRAY = new GFXColour(64, 64, 64);
    private final int mnRed;
    private final int mnGreen;
    private final int mnBlue;
    private final int mnScale;

    public GFXColour() {
        this.mnRed = 0;
        this.mnGreen = 0;
        this.mnBlue = 0;
        this.mnScale = 255;
    }

    public GFXColour(GFXColour oSource) {
        this.mnRed = oSource.mnRed;
        this.mnGreen = oSource.mnGreen;
        this.mnBlue = oSource.mnBlue;
        this.mnScale = oSource.mnScale;
    }

    public GFXColour(int lNewR, int lNewG, int lNewB, int lNewScale) {
        this.mnScale = lNewScale <= 0 ? 255 : lNewScale;
        this.mnRed = this.range(lNewR, this.mnScale);
        this.mnGreen = this.range(lNewG, this.mnScale);
        this.mnBlue = this.range(lNewB, this.mnScale);
    }

    public GFXColour(int lNewR, int lNewG, int lNewB) {
        this(lNewR, lNewG, lNewB, 255);
    }

    public GFXColour(String sColour) {
        int nStart = 0;
        int nEnd = sColour.indexOf(32);
        String sRGB = sColour.substring(nStart, nEnd);
        int lRValue = Integer.parseInt(sRGB);
        nStart = nEnd + 1;
        nEnd = sColour.indexOf(32, nStart);
        sRGB = sColour.substring(nStart, nEnd);
        int lGValue = Integer.parseInt(sRGB);
        nStart += nEnd + 1;
        nEnd = sColour.length();
        sRGB = sColour.substring(nStart, nEnd);
        int lBValue = Integer.parseInt(sRGB);
        this.mnScale = 255;
        this.mnRed = lRValue;
        this.mnGreen = lGValue;
        this.mnBlue = lBValue;
    }

    public static GFXColour create(int lNewR, int lNewG, int lNewB, int lNewScale) {
        if (lNewR == BLACK.r() && lNewG == BLACK.g() && lNewB == BLACK.b() && lNewScale == BLACK.scale()) {
            return BLACK;
        }
        if (lNewR == WHITE.r() && lNewG == WHITE.g() && lNewB == WHITE.b() && lNewScale == WHITE.scale()) {
            return WHITE;
        }
        if (lNewR == LIGHTGRAY.r() && lNewG == LIGHTGRAY.g() && lNewB == LIGHTGRAY.b() && lNewScale == LIGHTGRAY.scale()) {
            return LIGHTGRAY;
        }
        if (lNewR == GRAY.r() && lNewG == GRAY.g() && lNewB == GRAY.b() && lNewScale == GRAY.scale()) {
            return GRAY;
        }
        if (lNewR == DARKGRAY.r() && lNewG == DARKGRAY.g() && lNewB == DARKGRAY.b() && lNewScale == DARKGRAY.scale()) {
            return DARKGRAY;
        }
        return new GFXColour(lNewR, lNewG, lNewB, lNewScale);
    }

    public static GFXColour create(String sColour) {
        return new GFXColour(sColour);
    }

    public static GFXColour black() {
        return BLACK;
    }

    public static GFXColour white() {
        return WHITE;
    }

    public static GFXColour lightGray() {
        return LIGHTGRAY;
    }

    public static GFXColour gray() {
        return GRAY;
    }

    public static GFXColour darkGray() {
        return DARKGRAY;
    }

    public static GFXColour getStandardColour(int colourIndex) {
        switch (colourIndex) {
            case 0: {
                return BLACK;
            }
            case 1: {
                return WHITE;
            }
            case 2: {
                return LIGHTGRAY;
            }
            case 3: {
                return GRAY;
            }
            case 4: {
                return DARKGRAY;
            }
        }
        return null;
    }

    public static int getStandardColourIndex(GFXColour oColour) {
        if (oColour.equivalent(BLACK)) {
            return 0;
        }
        if (oColour.equivalent(WHITE)) {
            return 1;
        }
        if (oColour.equivalent(DARKGRAY)) {
            return 4;
        }
        if (oColour.equivalent(LIGHTGRAY)) {
            return 2;
        }
        if (oColour.equivalent(GRAY)) {
            return 3;
        }
        return 5;
    }

    public static boolean isBlack(GFXColour oColour) {
        return oColour.r() == 0 && oColour.g() == 0 && oColour.b() == 0;
    }

    public static boolean isWhite(GFXColour oColour) {
        int nScale = oColour.scale();
        return oColour.r() == nScale && oColour.g() == nScale && oColour.b() == nScale;
    }

    public int r() {
        return this.mnRed;
    }

    public int g() {
        return this.mnGreen;
    }

    public int b() {
        return this.mnBlue;
    }

    public boolean whiteMono() {
        return this.normalR() + this.normalG() + this.normalB() > 1.5;
    }

    public double normalR() {
        double dRed = this.mnRed;
        double dScale = this.mnScale;
        return dRed / dScale;
    }

    public double normalG() {
        double dGreen = this.mnGreen;
        double dScale = this.mnScale;
        return dGreen / dScale;
    }

    public double normalB() {
        double dBlue = this.mnBlue;
        double dScale = this.mnScale;
        return dBlue / dScale;
    }

    public int scale() {
        return this.mnScale;
    }

    public GFXColour scale(int newScale) {
        if (newScale == this.mnScale) {
            return this;
        }
        double scaleScale = (double)newScale / (double)this.mnScale;
        return new GFXColour((int)Math.round(scaleScale * (double)this.mnRed), (int)Math.round(scaleScale * (double)this.mnGreen), (int)Math.round(scaleScale * (double)this.mnBlue), newScale);
    }

    public boolean equivalent(GFXColour oCompare) {
        double rhs;
        if (this.mnScale == oCompare.mnScale && this.mnRed == oCompare.mnRed && this.mnBlue == oCompare.mnBlue && this.mnGreen == oCompare.mnGreen) {
            return true;
        }
        double lhs = this.normalR();
        if (lhs != (rhs = oCompare.normalR())) {
            return false;
        }
        lhs = this.normalG();
        if (lhs != (rhs = oCompare.normalG())) {
            return false;
        }
        lhs = this.normalB();
        return lhs == (rhs = oCompare.normalB());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        GFXColour colour = (GFXColour)object;
        return this.equivalent(colour);
    }

    public int hashCode() {
        int hash = 19;
        long color = Double.doubleToLongBits(this.normalR());
        hash = hash * 31 ^ (int)(color ^ color >>> 32);
        color = Double.doubleToLongBits(this.normalR());
        hash = hash * 31 ^ (int)(color ^ color >>> 32);
        color = Double.doubleToLongBits(this.normalR());
        hash = hash * 31 ^ (int)(color ^ color >>> 32);
        return hash;
    }

    public boolean notEqual(GFXColour oCompare) {
        return !this.equals(oCompare);
    }

    public int getGrayScale() {
        return (this.mnRed * 30 + this.mnGreen * 59 + this.mnBlue * 11) / 100;
    }

    public double getGrayRate() {
        return (double)(this.mnScale - this.getGrayScale()) / 2.55;
    }

    public static GFXColour weightedAverage(GFXColour base, GFXColour weighted, double weight) {
        return new GFXColour(GFXColour.weighComponent(base.normalR(), weighted.normalR(), weight, weighted.scale()), GFXColour.weighComponent(base.normalG(), weighted.normalG(), weight, weighted.scale()), GFXColour.weighComponent(base.normalB(), weighted.normalB(), weight, weighted.scale()), weighted.scale());
    }

    private static int weighComponent(double base, double weighted, double weight, int scale) {
        return (int)Math.round((base + weight * (weighted - base)) * (double)scale);
    }

    private int range(int lColour, int lScale) {
        if (lColour < 0) {
            return 0;
        }
        if (lColour > lScale) {
            return lScale;
        }
        return lColour;
    }
}

