/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template;

import com.adobe.xfa.content.ImageValue;
import com.adobe.xfa.template.formatting.Color;
import java.util.ArrayList;
import java.util.List;

public final class TemplateResolver {
    private final List<RGB> moActiveColorList = new ArrayList<RGB>();
    private final List<ImageValue> moImageList = new ArrayList<ImageValue>();

    public TemplateResolver() {
        RGB oWhite = new RGB(255, 255, 255);
        RGB oBlack = new RGB(0, 0, 0);
        this.moActiveColorList.add(oWhite);
        this.moActiveColorList.add(oBlack);
    }

    public void addActiveColor(Color oColor) {
        this.addActiveColor(oColor.getRed(), oColor.getGreen(), oColor.getBlue());
    }

    public void addActiveColor(int nRed, int nGreen, int nBlue) {
        boolean bFound = false;
        int nSize = this.moActiveColorList.size();
        for (int i = 0; i < nSize; ++i) {
            RGB color = this.moActiveColorList.get(i);
            if (color.mnRed != nRed || color.mnGreen != nGreen || color.mnBlue != nBlue) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            this.moActiveColorList.add(new RGB(nRed, nGreen, nBlue));
        }
    }

    public void addImage(ImageValue oImage) {
        boolean bFound = false;
        int nSize = this.moImageList.size();
        if (nSize > 0) {
            for (int i = 0; i < nSize; ++i) {
                if (this.moImageList.get(i) != oImage) continue;
                bFound = true;
                break;
            }
        }
        if (!bFound) {
            this.moImageList.add(oImage);
        }
    }

    public void cleanupImages() {
        this.moImageList.clear();
    }

    public List<RGB> enumActiveColors() {
        return this.moActiveColorList;
    }

    public List<ImageValue> getImages() {
        return this.moImageList;
    }

    public static class RGB {
        public final int mnBlue;
        public final int mnGreen;
        public final int mnRed;

        RGB(int red, int green, int blue) {
            this.mnRed = red;
            this.mnGreen = green;
            this.mnBlue = blue;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            RGB other = (RGB)object;
            return other.mnRed == this.mnRed && other.mnGreen == this.mnGreen && other.mnBlue == this.mnBlue;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 ^ this.mnBlue;
            hash = hash * 31 ^ this.mnGreen;
            hash = hash * 31 ^ this.mnRed;
            return hash;
        }
    }
}

