/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXDriver;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.DispTab;
import com.adobe.xfa.text.DrawParm;
import com.adobe.xfa.text.Glyph;
import com.adobe.xfa.text.GlyphLoc;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;

abstract class LeaderFill {
    private final DrawParm moDrawParm;
    private boolean mbSetup;
    private DispLineWrapped mpoLine;
    private TextAttr mpoAttr;
    private DispTab mpoDispTab;
    private GlyphLoc mpoGlyphLoc;
    private UnitSpan moBasePatternWidth;
    private UnitSpan moPatternWidth = UnitSpan.ZERO;
    private UnitSpan moPatternStart = UnitSpan.ZERO;
    private UnitSpan moTabX;
    private UnitSpan moTabWidth;
    private UnitSpan moTextOffset;
    private boolean mbRenderGlyph;
    private boolean mbSuppressAlign;

    LeaderFill(DrawParm oDrawParm) {
        this.moDrawParm = oDrawParm;
    }

    boolean setup(DispLineWrapped poLine, TextAttr poAttr, DispTab poDispTab, GlyphLoc poGlyphLoc) {
        this.mpoLine = poLine;
        this.mpoAttr = poAttr;
        this.mpoDispTab = poDispTab;
        this.mpoGlyphLoc = poGlyphLoc;
        this.moTabWidth = poDispTab.getFillWidth();
        if (this.moTabWidth.value() <= 0) {
            return false;
        }
        Glyph oGlyph = this.mpoLine.getGlyph(poGlyphLoc.getGlyphIndex());
        float oTabXBase = oGlyph.getDrawX(this.mpoLine) + Units.toFloat(this.mpoLine.getAMin());
        this.moTabX = Units.toUnitSpan(oTabXBase);
        this.moTextOffset = Units.toUnitSpan(this.mpoLine.dispHeight().textOffset(0));
        if (poAttr.leaderPatternWidthEnable()) {
            this.moPatternWidth = poAttr.leaderPatternWidth().getLength();
        }
        if (!this.onSetup()) {
            return false;
        }
        if (this.moPatternWidth.lt(this.moBasePatternWidth)) {
            this.moPatternWidth = this.moBasePatternWidth;
        }
        if (poAttr.leaderAlignEnable() && poAttr.leaderAlign() == 1 && !this.mbSuppressAlign && this.moPatternWidth.value() > 0) {
            UnitSpan oRawStart;
            CoordPair oAbsPoint = this.driver().offset(false);
            oAbsPoint = new CoordPair(oAbsPoint.x().add(this.moTabX), oAbsPoint.y().add(this.textOffset()));
            oAbsPoint = this.driver().rotatePoint(oAbsPoint);
            UnitSpan oLeft = UnitSpan.ZERO;
            UnitSpan oTop = UnitSpan.ZERO;
            UnitSpan oRight = UnitSpan.ZERO;
            UnitSpan oBottom = UnitSpan.ZERO;
            Rect oPage = this.moDrawParm.drawInfo().getPage();
            if (oPage != null) {
                oLeft = oPage.left();
                oTop = oPage.top();
                oRight = oPage.right();
                oBottom = oPage.bottom();
            }
            boolean bRTL = this.mpoLine.isRTL();
            int nDegrees = this.driver().angle(false).degrees();
            if (45 <= nDegrees && nDegrees < 135) {
                oRawStart = bRTL ? oAbsPoint.y().subtract(oTop) : oBottom.subtract(oAbsPoint.y());
            } else if (135 <= nDegrees && nDegrees < 225) {
                oRawStart = bRTL ? oAbsPoint.x().subtract(oLeft) : oRight.subtract(oAbsPoint.x());
            } else if (225 <= nDegrees && nDegrees < 315) {
                oRawStart = bRTL ? oBottom.subtract(oAbsPoint.y()) : oAbsPoint.y().subtract(oTop);
            } else {
                UnitSpan unitSpan = oRawStart = bRTL ? oRight.subtract(oAbsPoint.x()) : oAbsPoint.x().subtract(oLeft);
            }
            if (bRTL) {
                oRawStart = oRawStart.subtract(this.moTabWidth);
            }
            UnitSpan oGrid = new UnitSpan(this.moPatternWidth.units(), -this.moPatternWidth.value());
            this.moPatternStart = oRawStart.grid(oGrid);
            this.moPatternStart = this.moPatternStart.subtract(oRawStart);
        }
        if (this.moPatternStart.add(this.moBasePatternWidth).gt(this.moTabWidth)) {
            return false;
        }
        UnitSpan oPatternOffset = UnitSpan.ZERO;
        UnitSpan oPatternGap = this.moPatternWidth.subtract(this.moBasePatternWidth);
        switch (this.alignment()) {
            case 5: 
            case 11: {
                if (!this.mpoLine.isRTL()) break;
                oPatternOffset = oPatternGap;
                break;
            }
            case 6: 
            case 12: {
                oPatternOffset = oPatternGap.divide(2);
                break;
            }
            case 7: 
            case 13: {
                if (this.mpoLine.isRTL()) break;
                oPatternOffset = oPatternGap;
            }
        }
        this.moPatternStart = this.moPatternStart.add(oPatternOffset);
        assert (this.moPatternWidth.value() > 0);
        this.mbSetup = true;
        return true;
    }

    boolean render() {
        assert (this.mbSetup);
        UnitSpan oPatternEnd = this.moPatternStart.add(this.moBasePatternWidth);
        do {
            UnitSpan oOffsetX = this.mpoLine.isRTL() ? this.moTabWidth.subtract(oPatternEnd) : this.moPatternStart;
            this.onRender(this.moTabX.add(oOffsetX));
            this.moPatternStart = this.moPatternStart.add(this.moPatternWidth);
        } while ((oPatternEnd = this.moPatternStart.add(this.moBasePatternWidth)).lt(this.moTabWidth));
        this.mbSetup = false;
        return this.mbRenderGlyph;
    }

    DispLineWrapped line() {
        return this.mpoLine;
    }

    TextAttr attr() {
        return this.mpoAttr;
    }

    DrawParm drawParm() {
        return this.moDrawParm;
    }

    DispTab dispTab() {
        return this.mpoDispTab;
    }

    GlyphLoc glyphLoc() {
        return this.mpoGlyphLoc;
    }

    UnitSpan basePatternWidth() {
        return this.moBasePatternWidth;
    }

    void setBasePatternWidth(UnitSpan oBasePatternWidth) {
        this.moBasePatternWidth = oBasePatternWidth;
    }

    UnitSpan patternWidth() {
        return this.moPatternWidth;
    }

    void setPatternWidth(UnitSpan oPatternWidth) {
        this.moPatternWidth = oPatternWidth;
    }

    UnitSpan patternStart() {
        return this.moPatternStart;
    }

    void setPatternStart(UnitSpan oPatternStart) {
        this.moPatternStart = oPatternStart;
    }

    UnitSpan tabX() {
        return this.moTabX;
    }

    void setTabX(UnitSpan oTabX) {
        this.moTabX = oTabX;
    }

    UnitSpan tabWidth() {
        return this.moTabWidth;
    }

    void setTabWidth(UnitSpan oTabWidth) {
        this.moTabWidth = oTabWidth;
    }

    UnitSpan textOffset() {
        return this.moTextOffset;
    }

    void setTextOffset(UnitSpan oTextOffset) {
        this.moTextOffset = oTextOffset;
    }

    boolean renderGlyph() {
        return this.mbRenderGlyph;
    }

    void setRenderGlyph(boolean bRenderGlyph) {
        this.mbRenderGlyph = bRenderGlyph;
    }

    boolean suppressAlign() {
        return this.mbSuppressAlign;
    }

    void setSuppressAlign(boolean bSuppressAlign) {
        this.mbSuppressAlign = bSuppressAlign;
    }

    GFXDriver driver() {
        return this.moDrawParm.driver();
    }

    int alignment() {
        return this.mpoAttr.justifyH();
    }

    abstract boolean onSetup();

    abstract void onRender(UnitSpan var1);
}

