/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.protocol.Protocol;
import com.adobe.xfa.protocol.ProtocolUtils;
import com.adobe.xfa.ut.StringHolder;
import java.util.HashMap;
import java.util.Map;

public class Resolver {
    private static final ThreadLocal<Map<String, Protocol>> moProtocolRegistry = new ThreadLocal<Map<String, Protocol>>(){

        @Override
        protected synchronized Map<String, Protocol> initialValue() {
            return new HashMap<String, Protocol>();
        }
    };
    public static final String gsServerIndicator = "://";

    private Resolver() {
    }

    public static void setProtocol(Protocol oProtocol) {
        if (oProtocol != null) {
            String sScheme = oProtocol.scheme();
            moProtocolRegistry.get().put(sScheme, oProtocol);
        }
    }

    public static void resetProtocols() {
        moProtocolRegistry.get().clear();
    }

    public static Protocol getProtocol(String sScheme) {
        Protocol protocol;
        if (sScheme.endsWith(":")) {
            sScheme = sScheme.substring(0, sScheme.length() - 1);
        }
        if ((protocol = moProtocolRegistry.get().get(sScheme)) == null) {
            protocol = moProtocolRegistry.get().get("");
        }
        return protocol;
    }

    public static void crackUrl(String sUrl, StringHolder sScheme, StringHolder sUser, StringHolder sPwd, StringHolder sHost, StringHolder sPort, StringHolder sPath) {
        String sTmp = sUrl;
        int nFoundAt = 0;
        String sHostValue = null;
        nFoundAt = sTmp.indexOf(gsServerIndicator);
        if (nFoundAt != -1) {
            if (sScheme != null) {
                sScheme.value = sTmp.substring(0, nFoundAt);
            }
            sHostValue = sTmp.substring(nFoundAt + 3);
            if (sPath != null && (nFoundAt = sHostValue.indexOf(47)) != -1) {
                sPath.value = sHostValue.substring(nFoundAt + 1);
                sHostValue = sHostValue.substring(0, nFoundAt);
            }
        } else {
            nFoundAt = sTmp.indexOf(58);
            if (nFoundAt != -1) {
                if (sScheme != null) {
                    sScheme.value = sTmp.substring(0, nFoundAt);
                }
                sHostValue = sTmp.substring(nFoundAt + 1);
            }
        }
        if (sHostValue != null) {
            nFoundAt = sHostValue.indexOf(64);
            if (sUser != null && nFoundAt != -1) {
                sUser.value = sHostValue.substring(0, nFoundAt);
                sHostValue = sHostValue.substring(nFoundAt + 1);
                if (sPwd != null && (nFoundAt = sUser.value.indexOf(58)) != -1) {
                    sPwd.value = sUser.value.substring(nFoundAt + 1);
                    sUser.value = sUser.value.substring(0, nFoundAt);
                }
            }
            if (sPort != null) {
                int nOffset = sHostValue.indexOf(93);
                if (nOffset == -1) {
                    nOffset = 0;
                }
                if ((nFoundAt = sHostValue.indexOf(58, nOffset)) != -1) {
                    sPort.value = sHostValue.substring(nFoundAt + 1);
                    sHost.value = sHostValue.substring(0, nFoundAt);
                }
            }
        }
        if (sHost != null) {
            sHost.value = sHostValue;
        }
    }

    public static String canonUrl(String sScheme, String sHost, String sPort, String sPath) {
        StringBuilder sUrl = new StringBuilder(sScheme);
        if (sScheme.equals("file") || sScheme.equals("ftp") || sScheme.equals("ftps") || sScheme.equals("gopher") || sScheme.equals("http") || sScheme.equals("https") || sScheme.equals("ldap") || sScheme.equals("nntp") || sScheme.equals("telnet")) {
            sUrl.append(gsServerIndicator);
        } else {
            sUrl.append(':');
        }
        if (sHost != null) {
            sUrl.append(sHost);
        }
        if (sPort != null && sPort.length() > 0) {
            sUrl.append(':');
            sUrl.append(sPort);
        }
        if (sPath != null && sPath.length() > 0) {
            sUrl.append('/');
            sUrl.append(sPath);
        }
        return sUrl.toString();
    }

    public static String urlEncode(String sUrl) {
        String sEncodedPath;
        StringHolder sScheme = new StringHolder();
        StringHolder sUser = new StringHolder();
        StringHolder sPwd = new StringHolder();
        StringHolder sHost = new StringHolder();
        StringHolder sPort = new StringHolder();
        StringHolder sPath = new StringHolder();
        Resolver.crackUrl(sUrl, sScheme, sUser, sPwd, sHost, sPort, sPath);
        if (sPath.value != null && !(sEncodedPath = ProtocolUtils.urlEncode(sPath.value)).equals(sPath.value)) {
            return Resolver.canonUrl(sScheme.value, sHost.value, sPort.value, sEncodedPath);
        }
        return sUrl;
    }

    public static String urlDecode(String sUrl) {
        return ProtocolUtils.urlDecode(sUrl);
    }
}

