/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.watermark;

import com.day.cq.dam.commons.watermark.Font;
import com.day.cq.dam.commons.watermark.ImageWatermark;
import com.day.cq.dam.commons.watermark.Location;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class TextWatermark
extends ImageWatermark {
    public static final String COPYRIGHT = "\u00a9";
    private String text;
    private Font font;
    private boolean vertical;

    public TextWatermark(String text) {
        this.text = text;
        this.font = new Font();
    }

    public TextWatermark(String text, Font font) {
        this.text = text;
        this.font = font;
    }

    public TextWatermark(Location position, double orientation, float opacity, String text, Font font) {
        super(position, orientation, opacity);
        this.text = text;
        this.font = font;
    }

    public TextWatermark(int top, int left, double orientation, float opacity, String text, Font font) {
        super(top, left, orientation, opacity);
        this.text = text;
        this.font = font;
    }

    public TextWatermark(Location position, String text, Font font) {
        super(position);
        this.text = text;
        this.font = font;
    }

    public TextWatermark(int top, int left, String text, Font font) {
        super(top, left);
        this.text = text;
        this.font = font;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public BufferedImage getImage() {
        java.awt.Font textFont = new java.awt.Font(this.getFont().getFamily(), 0, this.font.getSize());
        FontRenderContext frc = new FontRenderContext(null, true, true);
        Rectangle2D bounds = textFont.getStringBounds(this.text, frc);
        int w = 0;
        int h = 0;
        if (this.vertical) {
            for (int i = 0; i < this.text.length(); ++i) {
                String character = this.text.substring(i, i + 1);
                Rectangle2D charBounds = textFont.getStringBounds(character, frc);
                h += (int)charBounds.getHeight();
                w = (int)charBounds.getWidth() > w ? (int)charBounds.getWidth() : w;
            }
        } else {
            w = (int)bounds.getWidth();
            h = (int)bounds.getHeight();
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, w, h);
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, w, h);
        g.setColor(this.font.getColor());
        g.setFont(textFont);
        if (this.vertical) {
            float x = (float)bounds.getX();
            float y = (float)(-bounds.getY());
            int charHeight = 0;
            for (int i = 0; i < this.text.length(); ++i) {
                String character = this.text.substring(i, i + 1);
                Rectangle2D charBounds = textFont.getStringBounds(character, frc);
                g.drawString(character, x, y += (float)charHeight);
                charHeight = (int)charBounds.getHeight();
            }
        } else {
            g.drawString(this.text, (float)bounds.getX(), (float)(-bounds.getY()));
        }
        g.dispose();
        return image;
    }

    @Override
    public String toString() {
        return super.toString() + "\ntext = " + this.text + "\nfont = " + this.font.toString();
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }
}

