/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.commons.util.PrefixRenditionPicker;
import java.awt.Dimension;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoProfile {
    private static final Logger log = LoggerFactory.getLogger(VideoProfile.class);
    public static final String PROFILE_BASE_PATH = "dam/video";
    public static final String PROFILE_TYPE_CQ = "dam/components/video/profile";
    public static final String PROFILE_TYPE_S7 = "dam/components/video/s7profile";
    public static final String PROFILES_CACONFIG_BUCKET = "settings";
    public static final String PROFILES_LEGACY_BUCKET = "/etc";
    private Resource resource;

    @Deprecated
    public static VideoProfile get(ResourceResolver resolver, String name) {
        Resource resource = null;
        if (name.startsWith("/")) {
            String path = name;
            log.warn("Resolution of Video Transcoding Profiles with absolute paths is deprecated. Use VideoProfile#get(ResourceResolver, ConfigurationResourceResolver, String) instead to resolve profiles-by-name using Sling Context-Aware Config Resolution");
            resource = resolver.getResource(path);
        } else {
            String path = "dam/video/" + name;
            log.warn("Video Transcoding Profiles in '/etc/dam/video' are deprecated. Create profiles under \"dam/video\" in \"settings\" bucket of Sling Context-Aware Configuration and use VideoProfile#get(ResourceResolver, ConfigurationResourceResolver, String) instead to resolve profiles-by-name using Sling Context-Aware Configuration Resolution");
            resource = resolver.getResource("/etc/" + path);
        }
        if (resource != null) {
            return new VideoProfile(resource);
        }
        return null;
    }

    public static VideoProfile get(ResourceResolver resolver, ConfigurationResourceResolver configResolver, String name) {
        String path = "dam/video/" + name;
        Resource tenantAssetRootResource = resolver.getResource(DamUtil.getTenantAssetsRoot(resolver));
        Resource resource = configResolver.getResource(tenantAssetRootResource, PROFILES_CACONFIG_BUCKET, path);
        VideoProfile profile = null;
        profile = resource != null ? new VideoProfile(resource) : VideoProfile.get(resolver, name);
        return profile;
    }

    public VideoProfile(Resource resource) {
        this.resource = "jcr:content".equals(resource.getName()) ? resource.getParent() : resource;
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public Resource getResource() {
        return this.resource;
    }

    public Resource getContentResource() {
        return this.resource.getResourceResolver().getResource(this.resource, "jcr:content");
    }

    public ValueMap getProperties() {
        return ResourceUtil.getValueMap(this.getContentResource());
    }

    public Node getContentNode() {
        Resource content = this.getContentResource();
        return content == null ? null : content.adaptTo(Node.class);
    }

    public String getHtmlType() {
        return this.getProperties().get("htmlType", "");
    }

    public Rendition getRendition(Asset asset) {
        if (this.isCQProfile()) {
            ValueMap props = this.getProperties();
            String renditionSelector = (String)props.get("renditionSelector");
            if (StringUtils.isEmpty(renditionSelector)) {
                renditionSelector = this.getName();
            }
            String prefix = "cq5dam.video." + renditionSelector;
            return asset.getRendition(new PrefixRenditionPicker(prefix));
        }
        if (this.isS7Profile()) {
            String prefix = "cq5dam.video.s7." + this.getPresetHandle();
            return asset.getRendition(new PrefixRenditionPicker(prefix));
        }
        return null;
    }

    public Dimension getOutputSize() {
        ValueMap props = this.getProperties();
        Integer width = (Integer)((Object)props.get("width", Integer.class));
        Integer height = (Integer)((Object)props.get("height", Integer.class));
        if (width != null && height != null) {
            return new Dimension(width, height);
        }
        return null;
    }

    public String getHtmlSource(Rendition rendition) {
        String htmlSource = "";
        if (rendition != null && this.isCQProfile()) {
            htmlSource = rendition.getPath();
        } else if (rendition != null && this.isS7Profile()) {
            htmlSource = this.getScene7Url(rendition);
        }
        return htmlSource;
    }

    public String getStrobeVideoSource(Rendition rendition) {
        String source = "";
        if (rendition != null && this.isCQProfile()) {
            source = "../../../../.." + rendition.getPath();
        } else if (rendition != null && this.isS7Profile()) {
            source = this.getScene7Url(rendition);
        }
        return source;
    }

    public String getFlvVideoSource(Rendition rendition) {
        String source = "";
        if (rendition != null && this.isCQProfile()) {
            source = rendition.getPath();
        } else if (rendition != null && this.isS7Profile()) {
            source = this.getScene7Url(rendition);
        }
        return source;
    }

    public String getCustomVideoSource(Rendition rendition) {
        return this.getFlvVideoSource(rendition);
    }

    private boolean isS7Profile() {
        return this.getResourceType().equals(PROFILE_TYPE_S7);
    }

    private boolean isCQProfile() {
        return this.getResourceType().equals(PROFILE_TYPE_CQ);
    }

    private String getResourceType() {
        String resourcType = "";
        Resource content = this.resource.getChild("jcr:content");
        if (content != null) {
            resourcType = content.getResourceType();
        }
        return resourcType;
    }

    private String getPresetHandle() {
        String presetHandle = this.getProperties().get("preset", "");
        if (StringUtils.isNotBlank(presetHandle)) {
            int lastIndex = presetHandle.lastIndexOf("/");
            presetHandle = presetHandle.substring(lastIndex + 1, presetHandle.length());
            presetHandle = presetHandle.replaceFirst("ps-", "");
        }
        return presetHandle;
    }

    private String getScene7Url(Rendition rendition) {
        String scene7Url = "";
        if (rendition != null) {
            scene7Url = rendition.getProperties().get("scene7.url", "");
        }
        return scene7Url;
    }
}

