/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.commons.ImageResource;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.foundation.ImageMap;
import com.day.cq.wcm.foundation.WCMRenditionPicker;
import com.day.text.Text;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;

public class Image
extends ImageResource {
    public static final String PN_IMAGE_MAP = "imageMap";
    private String imageMapId;
    private ImageMap imageMap = null;
    private boolean noPlaceholder;
    private Designer designer;
    private static final String DEFAULT_IMAGEPATH = "/resources/0.gif";

    public Image(Resource resource) {
        super(resource);
        this.designer = resource.getResourceResolver().adaptTo(Designer.class);
        if (this.properties.containsKey(PN_IMAGE_MAP)) {
            try {
                String mapDefinition = this.properties.get(PN_IMAGE_MAP, "");
                if (mapDefinition.length() > 0) {
                    this.imageMap = ImageMap.fromString(mapDefinition);
                    this.imageMapId = "map_" + Math.round(Math.random() * 2.147483647E9) + "_" + System.currentTimeMillis();
                }
            }
            catch (IllegalArgumentException iae) {
                this.imageMap = null;
                this.imageMapId = null;
            }
        }
        this.setTimewarpParametersIfSupported(resource);
    }

    private void setTimewarpParametersIfSupported(Resource resource) {
        Object timewarpTime = resource.getResourceResolver().getAttribute("timewarp");
        if (timewarpTime != null && timewarpTime instanceof Calendar) {
            long time = ((Calendar)timewarpTime).getTimeInMillis();
            this.addQueryParam("timewarp", String.valueOf(time));
            this.adjustSuffixToTimewarpTime(time);
        }
    }

    private void adjustSuffixToTimewarpTime(long time) {
        String suffix = this.getSuffix();
        String[] tokens = StringUtils.split(suffix, ".", 2);
        if (tokens.length == 2 && Long.parseLong(StringUtils.removeStart(tokens[0], "/")) > time) {
            this.setSuffix(String.valueOf(time) + '.' + tokens[1]);
        }
    }

    public Image(Resource resource, String imageName) {
        this(Image.getRelativeResource(resource, imageName));
    }

    public void setDropTargetId(String id, String classifier) {
        if (classifier == null) {
            classifier = "";
        }
        if (!classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        this.addCssClass("cq-dd-" + id + classifier);
    }

    public void setDropTargetId(String id) {
        String classifier = ResourceUtil.isNonExistingResource(this) ? String.valueOf(System.currentTimeMillis()) : Text.getName(this.getPath());
        this.setDropTargetId(id, classifier);
    }

    public boolean hasNoPlaceholder() {
        return this.noPlaceholder;
    }

    public void setNoPlaceholder(boolean noPlaceholder) {
        this.noPlaceholder = noPlaceholder;
    }

    public void loadStyleData(Style style) {
        if (style != null) {
            this.set("minWidth", style.get("minWidth", ""));
            this.set("minHeight", style.get("minHeight", ""));
            this.set("maxWidth", style.get("maxWidth", ""));
            this.set("maxHeight", style.get("maxHeight", ""));
        }
    }

    @Override
    protected boolean canDraw() {
        return !this.noPlaceholder || this.hasContent();
    }

    @Override
    protected Map<String, String> getImageTagAttributes() {
        String src = null;
        if (!this.hasContent()) {
            if (this.designer != null) {
                src = this.designer.getDefaultDesign().getPath() + DEFAULT_IMAGEPATH;
            }
            if (this.isTouchAuthoringUIMode()) {
                Map<String, String> attrs = this.getAttributes();
                if (attrs.get("data-emptytext") == null) {
                    this.addAttribute("data-emptytext", "Image");
                }
                this.addCssClass("cq-placeholder");
                this.addCssClass("file");
            } else {
                this.addCssClass("cq-image-placeholder");
            }
        }
        Map<String, String> attributes = super.getImageTagAttributes();
        if (src != null) {
            attributes.put("src", src);
        }
        if (this.imageMap != null) {
            attributes.put("usemap", "#" + this.imageMapId);
        }
        return attributes;
    }

    @Override
    protected void doDraw(PrintWriter w) {
        super.doDraw(w);
        if (this.imageMap != null) {
            w.print(this.imageMap.draw(this.imageMapId));
        }
    }

    @Override
    public String getIconPath() {
        Component c = WCMUtils.getComponent(this);
        if (c == null) {
            return null;
        }
        Resource icon = c.getLocalResource("resources/" + this.getIconType() + ".gif");
        if (icon == null) {
            icon = c.getLocalResource("resources/default.gif");
        }
        return icon == null ? null : icon.getPath();
    }

    @Override
    protected Resource getReferencedResource(String path) {
        Asset asset;
        Resource res = super.getReferencedResource(path);
        if (res != null && (asset = res.adaptTo(Asset.class)) != null) {
            Rendition rendition = asset.getRendition(new WCMRenditionPicker());
            res = null != rendition ? rendition.adaptTo(Resource.class) : null;
        }
        return res;
    }
}

