/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class TextFormat
extends Format {
    private static final String DEFAULT_BR = "<br>";
    private static final String DEFAULT_TAG_OL_OPEN = "<ol start=\"%s\">";
    private static final String DEFAULT_TAG_OL_CLOSE = "</ol>";
    private static final String DEFAULT_TAG_OL_ITEM_OPEN = "<li>";
    private static final String DEFAULT_TAG_OL_ITEM_CLOSE = "</li>";
    private static final String DEFAULT_TAG_UL_OPEN = "<ul>";
    private static final String DEFAULT_TAG_UL_CLOSE = "</ul>";
    private static final String DEFAULT_TAG_UL_ITEM_OPEN = "<li>";
    private static final String DEFAULT_TAG_UL_ITEM_CLOSE = "</li>";
    private static final int STATE_NORMAL = 1;
    private static final int STATE_OL = 3;
    private static final int STATE_UL = 4;
    private String tagBr = "<br>";
    private String tagOlOpen = "<ol start=\"%s\">";
    private String tagOlClose = "</ol>";
    private String tagOlItemOpen = "<li>";
    private String tagOlItemClose = "</li>";
    private String tagUlOpen = "<ul>";
    private String tagUlClose = "</ul>";
    private String tagUlItemOpen = "<li>";
    private String tagUlItemClose = "</li>";
    private boolean autoBr = true;
    private boolean autoList = true;
    private boolean escapeXML = true;

    public String getTagBr() {
        return this.tagBr;
    }

    public void setTagBr(String tagBr) {
        this.tagBr = tagBr;
    }

    public String getTagOlOpen() {
        return this.tagOlOpen;
    }

    public void setTagOlOpen(String tagOlOpen) {
        this.tagOlOpen = tagOlOpen;
    }

    public String getTagOlClose() {
        return this.tagOlClose;
    }

    public void setTagOlClose(String tagOlClose) {
        this.tagOlClose = tagOlClose;
    }

    public String getTagOlItemOpen() {
        return this.tagOlItemOpen;
    }

    public void setTagOlItemOpen(String tagOlItemOpen) {
        this.tagOlItemOpen = tagOlItemOpen;
    }

    public String getTagOlItemClose() {
        return this.tagOlItemClose;
    }

    public void setTagOlItemClose(String tagOlItemClose) {
        this.tagOlItemClose = tagOlItemClose;
    }

    public String getTagUlOpen() {
        return this.tagUlOpen;
    }

    public void setTagUlOpen(String tagUlOpen) {
        this.tagUlOpen = tagUlOpen;
    }

    public String getTagUlClose() {
        return this.tagUlClose;
    }

    public void setTagUlClose(String tagUlClose) {
        this.tagUlClose = tagUlClose;
    }

    public String getTagUlItemOpen() {
        return this.tagUlItemOpen;
    }

    public void setTagUlItemOpen(String tagUlItemOpen) {
        this.tagUlItemOpen = tagUlItemOpen;
    }

    public String getTagUlItemClose() {
        return this.tagUlItemClose;
    }

    public void setTagUlItemClose(String tagUlItemClose) {
        this.tagUlItemClose = tagUlItemClose;
    }

    public boolean isAutoBr() {
        return this.autoBr;
    }

    public void setAutoBr(boolean autoBr) {
        this.autoBr = autoBr;
    }

    public boolean isAutoList() {
        return this.autoList;
    }

    public void setAutoList(boolean autoList) {
        this.autoList = autoList;
    }

    public boolean isEscapeXML() {
        return this.escapeXML;
    }

    public void setEscapeXML(boolean escapeXML) {
        this.escapeXML = escapeXML;
    }

    @Override
    public Object parseObject(String source, ParsePosition status) {
        throw new UnsupportedOperationException("parse not implemented yet");
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        try {
            if (toAppendTo == null) {
                toAppendTo = new StringBuffer();
            }
            BufferedReader r = new BufferedReader(new StringReader(obj.toString()));
            String line = r.readLine();
            int state = 1;
            while (line != null) {
                int idx;
                boolean processed = false;
                if (this.autoList && (idx = line.indexOf(32)) > 0) {
                    String pfx = line.substring(0, idx);
                    if (pfx.equals("-")) {
                        if (state == 3) {
                            toAppendTo.append(this.tagOlClose);
                            state = 1;
                        }
                        if (state != 4) {
                            toAppendTo.append(this.tagUlOpen);
                            state = 4;
                        }
                        toAppendTo.append(this.tagUlItemOpen);
                        toAppendTo.append(this.escape(line.substring(idx + 1)));
                        toAppendTo.append(this.tagUlItemClose);
                        processed = true;
                    } else if (pfx.matches("^\\d+\\.$")) {
                        if (state == 4) {
                            toAppendTo.append(this.tagUlClose);
                            state = 1;
                        }
                        if (state != 3) {
                            toAppendTo.append(String.format(this.tagOlOpen, pfx.substring(0, pfx.length() - 1)));
                            state = 3;
                        }
                        toAppendTo.append(this.tagOlItemOpen);
                        toAppendTo.append(this.escape(line.substring(idx + 1)));
                        toAppendTo.append(this.tagOlItemClose);
                        processed = true;
                    }
                }
                if (!processed) {
                    if (state == 3) {
                        toAppendTo.append(this.tagOlClose);
                        state = 1;
                    } else if (state == 4) {
                        toAppendTo.append(this.tagUlClose);
                        state = 1;
                    }
                    toAppendTo.append(this.escape(line));
                    if (this.autoBr) {
                        toAppendTo.append(this.tagBr);
                    } else {
                        toAppendTo.append("\n");
                    }
                }
                line = r.readLine();
            }
            if (state == 3) {
                toAppendTo.append(this.tagOlClose);
            } else if (state == 4) {
                toAppendTo.append(this.tagUlClose);
            }
            return toAppendTo;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private CharSequence escape(String string) {
        if (!this.escapeXML) {
            return string;
        }
        StringBuffer buf = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf;
    }
}

