/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.tiff.TiffHandler;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.BufferBoundsException;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.Charsets;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.StringValue;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifImageDirectory;
import com.drew.metadata.exif.ExifInteropDirectory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.PanasonicRawDistortionDirectory;
import com.drew.metadata.exif.PanasonicRawIFD0Directory;
import com.drew.metadata.exif.PanasonicRawWbInfo2Directory;
import com.drew.metadata.exif.PanasonicRawWbInfoDirectory;
import com.drew.metadata.exif.PrintIMDirectory;
import com.drew.metadata.exif.makernotes.AppleMakernoteDirectory;
import com.drew.metadata.exif.makernotes.CanonMakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.FujifilmMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KodakMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KyoceraMakernoteDirectory;
import com.drew.metadata.exif.makernotes.LeicaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.LeicaType5MakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusCameraSettingsMakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusEquipmentMakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusFocusInfoMakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusImageProcessingMakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusMakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusRawDevelopment2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusRawDevelopmentMakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusRawInfoMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PanasonicMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PentaxMakernoteDirectory;
import com.drew.metadata.exif.makernotes.ReconyxHyperFireMakernoteDirectory;
import com.drew.metadata.exif.makernotes.ReconyxUltraFireMakernoteDirectory;
import com.drew.metadata.exif.makernotes.RicohMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SamsungType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.SanyoMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SigmaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType6MakernoteDirectory;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.photoshop.PhotoshopReader;
import com.drew.metadata.tiff.DirectoryTiffHandler;
import com.drew.metadata.xmp.XmpReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;

public class ExifTiffHandler
extends DirectoryTiffHandler {
    public ExifTiffHandler(@NotNull Metadata metadata, @Nullable Directory parentDirectory) {
        super(metadata, parentDirectory);
    }

    public void setTiffMarker(int marker) throws TiffProcessingException {
        int standardTiffMarker = 42;
        int olympusRawTiffMarker = 20306;
        int olympusRawTiffMarker2 = 21330;
        int panasonicRawTiffMarker = 85;
        switch (marker) {
            case 42: 
            case 20306: 
            case 21330: {
                this.pushDirectory(ExifIFD0Directory.class);
                break;
            }
            case 85: {
                this.pushDirectory(PanasonicRawIFD0Directory.class);
                break;
            }
            default: {
                throw new TiffProcessingException(String.format("Unexpected TIFF marker: 0x%X", marker));
            }
        }
    }

    public boolean tryEnterSubIfd(int tagId) {
        if (tagId == 330) {
            this.pushDirectory(ExifSubIFDDirectory.class);
            return true;
        }
        if (this._currentDirectory instanceof ExifIFD0Directory || this._currentDirectory instanceof PanasonicRawIFD0Directory) {
            if (tagId == 34665) {
                this.pushDirectory(ExifSubIFDDirectory.class);
                return true;
            }
            if (tagId == 34853) {
                this.pushDirectory(GpsDirectory.class);
                return true;
            }
        }
        if (this._currentDirectory instanceof ExifSubIFDDirectory && tagId == 40965) {
            this.pushDirectory(ExifInteropDirectory.class);
            return true;
        }
        if (this._currentDirectory instanceof OlympusMakernoteDirectory) {
            switch (tagId) {
                case 8208: {
                    this.pushDirectory(OlympusEquipmentMakernoteDirectory.class);
                    return true;
                }
                case 8224: {
                    this.pushDirectory(OlympusCameraSettingsMakernoteDirectory.class);
                    return true;
                }
                case 8240: {
                    this.pushDirectory(OlympusRawDevelopmentMakernoteDirectory.class);
                    return true;
                }
                case 8241: {
                    this.pushDirectory(OlympusRawDevelopment2MakernoteDirectory.class);
                    return true;
                }
                case 8256: {
                    this.pushDirectory(OlympusImageProcessingMakernoteDirectory.class);
                    return true;
                }
                case 8272: {
                    this.pushDirectory(OlympusFocusInfoMakernoteDirectory.class);
                    return true;
                }
                case 12288: {
                    this.pushDirectory(OlympusRawInfoMakernoteDirectory.class);
                    return true;
                }
                case 16384: {
                    this.pushDirectory(OlympusMakernoteDirectory.class);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasFollowerIfd() {
        if (this._currentDirectory instanceof ExifIFD0Directory || this._currentDirectory instanceof ExifImageDirectory) {
            if (this._currentDirectory.containsTag(297)) {
                this.pushDirectory(ExifImageDirectory.class);
            } else {
                this.pushDirectory(ExifThumbnailDirectory.class);
            }
            return true;
        }
        return this._currentDirectory instanceof ExifThumbnailDirectory;
    }

    @Nullable
    public Long tryCustomProcessFormat(int tagId, int formatCode, long componentCount) {
        if (formatCode == 13) {
            return componentCount * 4L;
        }
        if (formatCode == 0) {
            return 0L;
        }
        return null;
    }

    public boolean customProcessTag(int tagOffset, @NotNull Set<Integer> processedIfdOffsets, int tiffHeaderOffset, @NotNull RandomAccessReader reader, int tagId, int byteCount) throws IOException {
        assert (this._currentDirectory != null);
        if (tagId == 0) {
            if (this._currentDirectory.containsTag(tagId)) {
                return false;
            }
            if (byteCount == 0) {
                return true;
            }
        }
        if (tagId == 37500 && this._currentDirectory instanceof ExifSubIFDDirectory) {
            return this.processMakernote(tagOffset, processedIfdOffsets, tiffHeaderOffset, reader);
        }
        if (tagId == 33723 && this._currentDirectory instanceof ExifIFD0Directory) {
            if (reader.getInt8(tagOffset) == 28) {
                byte[] iptcBytes = reader.getBytes(tagOffset, byteCount);
                new IptcReader().extract(new SequentialByteArrayReader(iptcBytes), this._metadata, iptcBytes.length, this._currentDirectory);
                return true;
            }
            return false;
        }
        if (tagId == 34675) {
            byte[] iccBytes = reader.getBytes(tagOffset, byteCount);
            new IccReader().extract(new ByteArrayReader(iccBytes), this._metadata, this._currentDirectory);
            return true;
        }
        if (tagId == 34377 && this._currentDirectory instanceof ExifIFD0Directory) {
            byte[] photoshopBytes = reader.getBytes(tagOffset, byteCount);
            new PhotoshopReader().extract(new SequentialByteArrayReader(photoshopBytes), byteCount, this._metadata, this._currentDirectory);
            return true;
        }
        if (tagId == 700 && this._currentDirectory instanceof ExifIFD0Directory) {
            new XmpReader().extract(reader.getNullTerminatedBytes(tagOffset, byteCount), this._metadata, this._currentDirectory);
            return true;
        }
        if (ExifTiffHandler.handlePrintIM(this._currentDirectory, tagId)) {
            PrintIMDirectory printIMDirectory = new PrintIMDirectory();
            printIMDirectory.setParent(this._currentDirectory);
            this._metadata.addDirectory(printIMDirectory);
            ExifTiffHandler.processPrintIM(printIMDirectory, tagOffset, reader, byteCount);
            return true;
        }
        if (this._currentDirectory instanceof OlympusMakernoteDirectory) {
            switch (tagId) {
                case 8208: {
                    this.pushDirectory(OlympusEquipmentMakernoteDirectory.class);
                    TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, tagOffset, tiffHeaderOffset);
                    return true;
                }
                case 8224: {
                    this.pushDirectory(OlympusCameraSettingsMakernoteDirectory.class);
                    TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, tagOffset, tiffHeaderOffset);
                    return true;
                }
                case 8240: {
                    this.pushDirectory(OlympusRawDevelopmentMakernoteDirectory.class);
                    TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, tagOffset, tiffHeaderOffset);
                    return true;
                }
                case 8241: {
                    this.pushDirectory(OlympusRawDevelopment2MakernoteDirectory.class);
                    TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, tagOffset, tiffHeaderOffset);
                    return true;
                }
                case 8256: {
                    this.pushDirectory(OlympusImageProcessingMakernoteDirectory.class);
                    TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, tagOffset, tiffHeaderOffset);
                    return true;
                }
                case 8272: {
                    this.pushDirectory(OlympusFocusInfoMakernoteDirectory.class);
                    TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, tagOffset, tiffHeaderOffset);
                    return true;
                }
                case 12288: {
                    this.pushDirectory(OlympusRawInfoMakernoteDirectory.class);
                    TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, tagOffset, tiffHeaderOffset);
                    return true;
                }
                case 16384: {
                    this.pushDirectory(OlympusMakernoteDirectory.class);
                    TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, tagOffset, tiffHeaderOffset);
                    return true;
                }
            }
        }
        if (this._currentDirectory instanceof PanasonicRawIFD0Directory) {
            switch (tagId) {
                case 19: {
                    PanasonicRawWbInfoDirectory dirWbInfo = new PanasonicRawWbInfoDirectory();
                    dirWbInfo.setParent(this._currentDirectory);
                    this._metadata.addDirectory(dirWbInfo);
                    ExifTiffHandler.processBinary(dirWbInfo, tagOffset, reader, byteCount, false, 2);
                    return true;
                }
                case 39: {
                    PanasonicRawWbInfo2Directory dirWbInfo2 = new PanasonicRawWbInfo2Directory();
                    dirWbInfo2.setParent(this._currentDirectory);
                    this._metadata.addDirectory(dirWbInfo2);
                    ExifTiffHandler.processBinary(dirWbInfo2, tagOffset, reader, byteCount, false, 3);
                    return true;
                }
                case 281: {
                    PanasonicRawDistortionDirectory dirDistort = new PanasonicRawDistortionDirectory();
                    dirDistort.setParent(this._currentDirectory);
                    this._metadata.addDirectory(dirDistort);
                    ExifTiffHandler.processBinary(dirDistort, tagOffset, reader, byteCount, true, 1);
                    return true;
                }
            }
        }
        if (tagId == 46 && this._currentDirectory instanceof PanasonicRawIFD0Directory) {
            byte[] jpegrawbytes = reader.getBytes(tagOffset, byteCount);
            ByteArrayInputStream jpegmem = new ByteArrayInputStream(jpegrawbytes);
            try {
                Metadata jpegDirectory = JpegMetadataReader.readMetadata(jpegmem);
                for (Directory directory : jpegDirectory.getDirectories()) {
                    directory.setParent(this._currentDirectory);
                    this._metadata.addDirectory(directory);
                }
                return true;
            }
            catch (JpegProcessingException e) {
                this._currentDirectory.addError("Error processing JpgFromRaw: " + e.getMessage());
            }
            catch (IOException e) {
                this._currentDirectory.addError("Error reading JpgFromRaw: " + e.getMessage());
            }
        }
        return false;
    }

    private static void processBinary(@NotNull Directory directory, int tagValueOffset, @NotNull RandomAccessReader reader, int byteCount, Boolean isSigned, int arrayLength) throws IOException {
        int byteSize = 2;
        for (int i = 0; i < byteCount; ++i) {
            int j;
            Object[] val;
            if (!directory.hasTagName(i)) continue;
            if (i < byteCount - 1 && directory.hasTagName(i + 1)) {
                if (isSigned.booleanValue()) {
                    directory.setObject(i, reader.getInt16(tagValueOffset + i * byteSize));
                    continue;
                }
                directory.setObject(i, reader.getUInt16(tagValueOffset + i * byteSize));
                continue;
            }
            if (isSigned.booleanValue()) {
                val = new short[arrayLength];
                for (j = 0; j < val.length; ++j) {
                    val[j] = reader.getInt16(tagValueOffset + (i + j) * byteSize);
                }
                directory.setObjectArray(i, val);
            } else {
                val = new int[arrayLength];
                for (j = 0; j < val.length; ++j) {
                    val[j] = reader.getUInt16(tagValueOffset + (i + j) * byteSize);
                }
                directory.setObjectArray(i, val);
            }
            i += arrayLength - 1;
        }
    }

    @NotNull
    private static String getReaderString(@NotNull RandomAccessReader reader, int makernoteOffset, int bytesRequested) throws IOException {
        try {
            return reader.getString(makernoteOffset, bytesRequested, Charsets.UTF_8);
        }
        catch (BufferBoundsException e) {
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processMakernote(int makernoteOffset, @NotNull Set<Integer> processedIfdOffsets, int tiffHeaderOffset, @NotNull RandomAccessReader reader) throws IOException {
        assert (this._currentDirectory != null);
        ExifIFD0Directory ifd0Directory = this._metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        String cameraMake = ifd0Directory == null ? null : ifd0Directory.getString(271);
        String firstTwoChars = ExifTiffHandler.getReaderString(reader, makernoteOffset, 2);
        String firstThreeChars = ExifTiffHandler.getReaderString(reader, makernoteOffset, 3);
        String firstFourChars = ExifTiffHandler.getReaderString(reader, makernoteOffset, 4);
        String firstFiveChars = ExifTiffHandler.getReaderString(reader, makernoteOffset, 5);
        String firstSixChars = ExifTiffHandler.getReaderString(reader, makernoteOffset, 6);
        String firstSevenChars = ExifTiffHandler.getReaderString(reader, makernoteOffset, 7);
        String firstEightChars = ExifTiffHandler.getReaderString(reader, makernoteOffset, 8);
        String firstNineChars = ExifTiffHandler.getReaderString(reader, makernoteOffset, 9);
        String firstTenChars = ExifTiffHandler.getReaderString(reader, makernoteOffset, 10);
        String firstTwelveChars = ExifTiffHandler.getReaderString(reader, makernoteOffset, 12);
        boolean byteOrderBefore = reader.isMotorolaByteOrder();
        if ("OLYMP\u0000".equals(firstSixChars) || "EPSON".equals(firstFiveChars) || "AGFA".equals(firstFourChars)) {
            this.pushDirectory(OlympusMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset);
        } else if ("OLYMPUS\u0000II".equals(firstTenChars)) {
            this.pushDirectory(OlympusMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 12, makernoteOffset);
        } else if (cameraMake != null && cameraMake.toUpperCase().startsWith("MINOLTA")) {
            this.pushDirectory(OlympusMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset, tiffHeaderOffset);
        } else if (cameraMake != null && cameraMake.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(firstFiveChars)) {
                switch (reader.getUInt8(makernoteOffset + 6)) {
                    case 1: {
                        this.pushDirectory(NikonType1MakernoteDirectory.class);
                        TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset);
                        break;
                    }
                    case 2: {
                        this.pushDirectory(NikonType2MakernoteDirectory.class);
                        TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 18, makernoteOffset + 10);
                        break;
                    }
                    default: {
                        this._currentDirectory.addError("Unsupported Nikon makernote data ignored.");
                        break;
                    }
                }
            } else {
                this.pushDirectory(NikonType2MakernoteDirectory.class);
                TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset, tiffHeaderOffset);
            }
        } else if ("SONY CAM".equals(firstEightChars) || "SONY DSC".equals(firstEightChars)) {
            this.pushDirectory(SonyType1MakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 12, tiffHeaderOffset);
        } else if (cameraMake != null && cameraMake.startsWith("SONY") && !Arrays.equals(reader.getBytes(makernoteOffset, 2), new byte[]{1, 0})) {
            this.pushDirectory(SonyType1MakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset, tiffHeaderOffset);
        } else if ("SEMC MS\u0000\u0000\u0000\u0000\u0000".equals(firstTwelveChars)) {
            reader.setMotorolaByteOrder(true);
            this.pushDirectory(SonyType6MakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 20, tiffHeaderOffset);
        } else if ("SIGMA\u0000\u0000\u0000".equals(firstEightChars) || "FOVEON\u0000\u0000".equals(firstEightChars)) {
            this.pushDirectory(SigmaMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 10, tiffHeaderOffset);
        } else if ("KDK".equals(firstThreeChars)) {
            reader.setMotorolaByteOrder(firstSevenChars.equals("KDK INFO"));
            KodakMakernoteDirectory directory = new KodakMakernoteDirectory();
            this._metadata.addDirectory(directory);
            ExifTiffHandler.processKodakMakernote(directory, makernoteOffset, reader);
        } else if ("Canon".equalsIgnoreCase(cameraMake)) {
            this.pushDirectory(CanonMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset, tiffHeaderOffset);
        } else if (cameraMake != null && cameraMake.toUpperCase().startsWith("CASIO")) {
            if ("QVC\u0000\u0000\u0000".equals(firstSixChars)) {
                this.pushDirectory(CasioType2MakernoteDirectory.class);
                TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 6, tiffHeaderOffset);
            } else {
                this.pushDirectory(CasioType1MakernoteDirectory.class);
                TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset, tiffHeaderOffset);
            }
        } else if ("FUJIFILM".equals(firstEightChars) || "Fujifilm".equalsIgnoreCase(cameraMake)) {
            reader.setMotorolaByteOrder(false);
            int ifdStart = makernoteOffset + reader.getInt32(makernoteOffset + 8);
            this.pushDirectory(FujifilmMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, ifdStart, makernoteOffset);
        } else if ("KYOCERA".equals(firstSevenChars)) {
            this.pushDirectory(KyoceraMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 22, tiffHeaderOffset);
        } else if ("LEICA".equals(firstFiveChars)) {
            reader.setMotorolaByteOrder(false);
            if ("LEICA\u0000\u0001\u0000".equals(firstEightChars) || "LEICA\u0000\u0004\u0000".equals(firstEightChars) || "LEICA\u0000\u0005\u0000".equals(firstEightChars) || "LEICA\u0000\u0006\u0000".equals(firstEightChars) || "LEICA\u0000\u0007\u0000".equals(firstEightChars)) {
                this.pushDirectory(LeicaType5MakernoteDirectory.class);
                TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 8, makernoteOffset);
            } else if ("Leica Camera AG".equals(cameraMake)) {
                this.pushDirectory(LeicaMakernoteDirectory.class);
                TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset);
            } else {
                if (!"LEICA".equals(cameraMake)) return false;
                this.pushDirectory(PanasonicMakernoteDirectory.class);
                TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset);
            }
        } else if ("Panasonic\u0000\u0000\u0000".equals(firstTwelveChars)) {
            this.pushDirectory(PanasonicMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 12, tiffHeaderOffset);
        } else if ("AOC\u0000".equals(firstFourChars)) {
            this.pushDirectory(CasioType2MakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 6, makernoteOffset);
        } else if (cameraMake != null && (cameraMake.toUpperCase().startsWith("PENTAX") || cameraMake.toUpperCase().startsWith("ASAHI"))) {
            this.pushDirectory(PentaxMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset, makernoteOffset);
        } else if ("SANYO\u0000\u0001\u0000".equals(firstEightChars)) {
            this.pushDirectory(SanyoMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 8, makernoteOffset);
        } else if (cameraMake != null && cameraMake.toLowerCase().startsWith("ricoh")) {
            if (firstTwoChars.equals("Rv") || firstThreeChars.equals("Rev")) {
                return false;
            }
            if (firstFiveChars.equalsIgnoreCase("Ricoh")) {
                reader.setMotorolaByteOrder(true);
                this.pushDirectory(RicohMakernoteDirectory.class);
                TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 8, makernoteOffset);
            }
        } else if (firstTenChars.equals("Apple iOS\u0000")) {
            boolean orderBefore = reader.isMotorolaByteOrder();
            reader.setMotorolaByteOrder(true);
            this.pushDirectory(AppleMakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset + 14, makernoteOffset);
            reader.setMotorolaByteOrder(orderBefore);
        } else if (reader.getUInt16(makernoteOffset) == 61697) {
            ReconyxHyperFireMakernoteDirectory directory = new ReconyxHyperFireMakernoteDirectory();
            this._metadata.addDirectory(directory);
            ExifTiffHandler.processReconyxHyperFireMakernote(directory, makernoteOffset, reader);
        } else if (firstNineChars.equalsIgnoreCase("RECONYXUF")) {
            ReconyxUltraFireMakernoteDirectory directory = new ReconyxUltraFireMakernoteDirectory();
            this._metadata.addDirectory(directory);
            ExifTiffHandler.processReconyxUltraFireMakernote(directory, makernoteOffset, reader);
        } else {
            if (!"SAMSUNG".equals(cameraMake)) return false;
            this.pushDirectory(SamsungType2MakernoteDirectory.class);
            TiffReader.processIfd((TiffHandler)((Object)this), reader, processedIfdOffsets, makernoteOffset, tiffHeaderOffset);
        }
        reader.setMotorolaByteOrder(byteOrderBefore);
        return true;
    }

    private static boolean handlePrintIM(@NotNull Directory directory, int tagId) {
        if (tagId == 50341) {
            return true;
        }
        return tagId == 3584 && (directory instanceof CasioType2MakernoteDirectory || directory instanceof KyoceraMakernoteDirectory || directory instanceof NikonType2MakernoteDirectory || directory instanceof OlympusMakernoteDirectory || directory instanceof PanasonicMakernoteDirectory || directory instanceof PentaxMakernoteDirectory || directory instanceof RicohMakernoteDirectory || directory instanceof SanyoMakernoteDirectory || directory instanceof SonyType1MakernoteDirectory);
    }

    private static void processPrintIM(@NotNull PrintIMDirectory directory, int tagValueOffset, @NotNull RandomAccessReader reader, int byteCount) throws IOException {
        Boolean resetByteOrder = null;
        if (byteCount == 0) {
            directory.addError("Empty PrintIM data");
            return;
        }
        if (byteCount <= 15) {
            directory.addError("Bad PrintIM data");
            return;
        }
        String header = reader.getString(tagValueOffset, 12, Charsets.UTF_8);
        if (!header.startsWith("PrintIM")) {
            directory.addError("Invalid PrintIM header");
            return;
        }
        int num = reader.getUInt16(tagValueOffset + 14);
        if (byteCount < 16 + num * 6) {
            resetByteOrder = reader.isMotorolaByteOrder();
            reader.setMotorolaByteOrder(!reader.isMotorolaByteOrder());
            num = reader.getUInt16(tagValueOffset + 14);
            if (byteCount < 16 + num * 6) {
                directory.addError("Bad PrintIM size");
                return;
            }
        }
        directory.setObject(0, header.substring(8, 12));
        for (int n = 0; n < num; ++n) {
            int pos = tagValueOffset + 16 + n * 6;
            int tag = reader.getUInt16(pos);
            long val = reader.getUInt32(pos + 2);
            directory.setObject(tag, val);
        }
        if (resetByteOrder != null) {
            reader.setMotorolaByteOrder(resetByteOrder);
        }
    }

    private static void processKodakMakernote(@NotNull KodakMakernoteDirectory directory, int tagValueOffset, @NotNull RandomAccessReader reader) {
        int dataOffset = tagValueOffset + 8;
        try {
            directory.setStringValue(0, reader.getStringValue(dataOffset, 8, Charsets.UTF_8));
            directory.setInt(9, (int)reader.getUInt8(dataOffset + 9));
            directory.setInt(10, (int)reader.getUInt8(dataOffset + 10));
            directory.setInt(12, reader.getUInt16(dataOffset + 12));
            directory.setInt(14, reader.getUInt16(dataOffset + 14));
            directory.setInt(16, reader.getUInt16(dataOffset + 16));
            directory.setByteArray(18, reader.getBytes(dataOffset + 18, 2));
            directory.setByteArray(20, reader.getBytes(dataOffset + 20, 4));
            directory.setInt(24, reader.getUInt16(dataOffset + 24));
            directory.setInt(27, (int)reader.getUInt8(dataOffset + 27));
            directory.setInt(28, (int)reader.getUInt8(dataOffset + 28));
            directory.setInt(29, (int)reader.getUInt8(dataOffset + 29));
            directory.setInt(30, reader.getUInt16(dataOffset + 30));
            directory.setLong(32, reader.getUInt32(dataOffset + 32));
            directory.setInt(36, (int)reader.getInt16(dataOffset + 36));
            directory.setInt(56, (int)reader.getUInt8(dataOffset + 56));
            directory.setInt(64, (int)reader.getUInt8(dataOffset + 64));
            directory.setInt(92, (int)reader.getUInt8(dataOffset + 92));
            directory.setInt(93, (int)reader.getUInt8(dataOffset + 93));
            directory.setInt(94, reader.getUInt16(dataOffset + 94));
            directory.setInt(96, reader.getUInt16(dataOffset + 96));
            directory.setInt(98, reader.getUInt16(dataOffset + 98));
            directory.setInt(100, reader.getUInt16(dataOffset + 100));
            directory.setInt(102, reader.getUInt16(dataOffset + 102));
            directory.setInt(104, reader.getUInt16(dataOffset + 104));
            directory.setInt(107, (int)reader.getInt8(dataOffset + 107));
        }
        catch (IOException ex) {
            directory.addError("Error processing Kodak makernote data: " + ex.getMessage());
        }
    }

    private static void processReconyxHyperFireMakernote(@NotNull ReconyxHyperFireMakernoteDirectory directory, int makernoteOffset, @NotNull RandomAccessReader reader) throws IOException {
        Integer build;
        directory.setObject(0, (Object)reader.getUInt16(makernoteOffset));
        int major = reader.getUInt16(makernoteOffset + 2);
        int minor = reader.getUInt16(makernoteOffset + 2 + 2);
        int revision = reader.getUInt16(makernoteOffset + 2 + 4);
        String buildYear = String.format("%04X", reader.getUInt16(makernoteOffset + 2 + 6));
        String buildDate = String.format("%04X", reader.getUInt16(makernoteOffset + 2 + 8));
        String buildYearAndDate = buildYear + buildDate;
        try {
            build = Integer.parseInt(buildYearAndDate);
        }
        catch (NumberFormatException e) {
            build = null;
        }
        if (build != null) {
            directory.setString(2, String.format("%d.%d.%d.%s", major, minor, revision, build));
        } else {
            directory.setString(2, String.format("%d.%d.%d", major, minor, revision));
            directory.addError("Error processing Reconyx HyperFire makernote data: build '" + buildYearAndDate + "' is not in the expected format and will be omitted from Firmware Version.");
        }
        directory.setString(12, String.valueOf((char)reader.getUInt16(makernoteOffset + 12)));
        directory.setIntArray(14, new int[]{reader.getUInt16(makernoteOffset + 14), reader.getUInt16(makernoteOffset + 14 + 2)});
        int eventNumberHigh = reader.getUInt16(makernoteOffset + 18);
        int eventNumberLow = reader.getUInt16(makernoteOffset + 18 + 2);
        directory.setInt(18, (eventNumberHigh << 16) + eventNumberLow);
        int seconds = reader.getUInt16(makernoteOffset + 22);
        int minutes = reader.getUInt16(makernoteOffset + 22 + 2);
        int hour = reader.getUInt16(makernoteOffset + 22 + 4);
        int month = reader.getUInt16(makernoteOffset + 22 + 6);
        int day = reader.getUInt16(makernoteOffset + 22 + 8);
        int year = reader.getUInt16(makernoteOffset + 22 + 10);
        if (seconds >= 0 && seconds < 60 && minutes >= 0 && minutes < 60 && hour >= 0 && hour < 24 && month >= 1 && month < 13 && day >= 1 && day < 32 && year >= 1 && year <= 9999) {
            directory.setString(22, String.format("%4d:%2d:%2d %2d:%2d:%2d", year, month, day, hour, minutes, seconds));
        } else {
            directory.addError("Error processing Reconyx HyperFire makernote data: Date/Time Original " + year + "-" + month + "-" + day + " " + hour + ":" + minutes + ":" + seconds + " is not a valid date/time.");
        }
        directory.setInt(36, reader.getUInt16(makernoteOffset + 36));
        directory.setInt(38, (int)reader.getInt16(makernoteOffset + 38));
        directory.setInt(40, (int)reader.getInt16(makernoteOffset + 40));
        directory.setStringValue(42, new StringValue(reader.getBytes(makernoteOffset + 42, 28), Charsets.UTF_16LE));
        directory.setInt(72, reader.getUInt16(makernoteOffset + 72));
        directory.setInt(74, reader.getUInt16(makernoteOffset + 74));
        directory.setInt(76, reader.getUInt16(makernoteOffset + 76));
        directory.setInt(78, reader.getUInt16(makernoteOffset + 78));
        directory.setInt(80, reader.getUInt16(makernoteOffset + 80));
        directory.setInt(82, reader.getUInt16(makernoteOffset + 82));
        directory.setDouble(84, (double)reader.getUInt16(makernoteOffset + 84) / 1000.0);
        directory.setString(86, reader.getNullTerminatedString(makernoteOffset + 86, 44, Charsets.UTF_8));
    }

    private static void processReconyxUltraFireMakernote(@NotNull ReconyxUltraFireMakernoteDirectory directory, int makernoteOffset, @NotNull RandomAccessReader reader) throws IOException {
        directory.setString(0, reader.getString(makernoteOffset, 9, Charsets.UTF_8));
        directory.setString(52, reader.getString(makernoteOffset + 52, 1, Charsets.UTF_8));
        directory.setIntArray(53, new int[]{reader.getByte(makernoteOffset + 53), reader.getByte(makernoteOffset + 53 + 1)});
        byte seconds = reader.getByte(makernoteOffset + 59);
        byte minutes = reader.getByte(makernoteOffset + 59 + 1);
        byte hour = reader.getByte(makernoteOffset + 59 + 2);
        byte day = reader.getByte(makernoteOffset + 59 + 3);
        byte month = reader.getByte(makernoteOffset + 59 + 4);
        directory.setInt(67, (int)reader.getByte(makernoteOffset + 67));
        directory.setInt(72, (int)reader.getByte(makernoteOffset + 72));
        directory.setStringValue(75, new StringValue(reader.getBytes(makernoteOffset + 75, 14), Charsets.UTF_8));
        directory.setString(80, reader.getNullTerminatedString(makernoteOffset + 80, 20, Charsets.UTF_8));
    }
}

