/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.internal.lang3.Validate;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTemplateLoader
implements TemplateLoader {
    private static final Logger logger = LoggerFactory.getLogger(CompositeTemplateLoader.class);
    private final TemplateLoader[] delegates;

    public CompositeTemplateLoader(TemplateLoader ... loaders) {
        Validate.isTrue((loaders.length > 1 ? 1 : 0) != 0, (String)"At least two loaders are required.", (Object[])new Object[0]);
        this.delegates = loaders;
    }

    @Override
    public TemplateSource sourceAt(String location) throws IOException {
        for (TemplateLoader delegate : this.delegates) {
            try {
                return delegate.sourceAt(location);
            }
            catch (IOException ex) {
                logger.trace("Unable to resolve: {}, trying next loader in the chain.", (Object)location);
            }
        }
        throw new FileNotFoundException(location);
    }

    @Override
    public String resolve(String location) {
        for (TemplateLoader delegate : this.delegates) {
            try {
                delegate.sourceAt(location);
                return delegate.resolve(location);
            }
            catch (IOException ex) {
                logger.trace("Unable to resolve: {}, trying next loader in the chain.", (Object)location);
            }
        }
        throw new IllegalStateException("Can't resolve: '" + location + "'");
    }

    @Override
    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSuffix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrefix(String prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSuffix(String suffix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharset(Charset charset) {
        for (TemplateLoader delegate : this.delegates) {
            delegate.setCharset(charset);
        }
    }

    @Override
    public Charset getCharset() {
        throw new UnsupportedOperationException();
    }

    public Iterable<TemplateLoader> getDelegates() {
        return Arrays.asList(this.delegates);
    }
}

