/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.DefaultBrandingPlugin;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.VariableResolver;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Deprecated(since="2021-04-30")
public abstract class AbstractWebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String ATTR_FILEUPLOAD = "org.apache.felix.webconsole.fileupload";
    public static final String ATTR_FILEUPLOAD_REPO = "org.apache.felix.webconsole.fileupload.repo";
    public static final String GET_RESOURCE_METHOD_NAME = "getResource";
    private static String HEADER;
    private static String FOOTER;
    private Method getResourceMethod;
    private boolean getResourceMethodChecked;
    private BundleContext bundleContext;
    private static BrandingPlugin brandingPlugin;
    private static int logLevel;

    @Override
    public String getServletName() {
        return this.getTitle();
    }

    public String getCategory() {
        return null;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.spoolResource(request, response)) {
            if (this.isHtmlRequest(request)) {
                PrintWriter pw = this.startResponse(request, response);
                this.renderTopNavigation(request, pw);
                pw.println("<div id='content'>");
                this.renderContent(request, response);
                pw.println("</div>");
                this.endResponse(pw);
            } else {
                this.renderContent(request, response);
            }
        }
    }

    protected boolean isHtmlRequest(HttpServletRequest request) {
        return true;
    }

    public void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void deactivate() {
        this.bundleContext = null;
    }

    protected abstract void renderContent(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public abstract String getLabel();

    public abstract String getTitle();

    protected String[] getCssReferences() {
        return null;
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public final Bundle getBundle() {
        BundleContext bundleContext = this.getBundleContext();
        return bundleContext != null ? bundleContext.getBundle() : null;
    }

    protected Object getResourceProvider() {
        return this;
    }

    private final Method getGetResourceMethod() {
        if (this.getResourceMethodChecked) {
            return this.getResourceMethod;
        }
        Method tmpGetResourceMethod = null;
        Object resourceProvider = this.getResourceProvider();
        if (resourceProvider != null) {
            try {
                block2: for (Class<?> cl = resourceProvider.getClass(); tmpGetResourceMethod == null && cl != Object.class; cl = cl.getSuperclass()) {
                    Method[] methods = cl.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        int mod;
                        Method m = methods[i];
                        if (!GET_RESOURCE_METHOD_NAME.equals(m.getName()) || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != String.class || m.getReturnType() != URL.class || !Modifier.isProtected(mod = m.getModifiers()) && !Modifier.isPublic(mod) && (!Modifier.isPrivate(mod) || cl != resourceProvider.getClass())) continue;
                        m.setAccessible(true);
                        tmpGetResourceMethod = m;
                        continue block2;
                    }
                }
            }
            catch (Throwable t) {
                tmpGetResourceMethod = null;
            }
        }
        this.getResourceMethod = tmpGetResourceMethod;
        this.getResourceMethodChecked = true;
        return this.getResourceMethod;
    }

    public void log(int level, String message) {
        if (logLevel >= level) {
            ServletContext context;
            ServletConfig config = this.getServletConfig();
            if (config != null && (context = config.getServletContext()) != null) {
                context.log(message);
                return;
            }
            System.err.println(message);
        }
    }

    public void log(int level, String message, Throwable t) {
        if (logLevel >= level) {
            ServletContext context;
            ServletConfig config = this.getServletConfig();
            if (config != null && (context = config.getServletContext()) != null) {
                context.log(message, t);
                return;
            }
            System.err.println(message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    private final boolean spoolResource(final HttpServletRequest request, final HttpServletResponse response) throws IOException {
        try {
            Boolean ret = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return AbstractWebConsolePlugin.this.spoolResource0(request, response) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            return ret;
        }
        catch (PrivilegedActionException e) {
            Exception x = e.getException();
            throw x instanceof IOException ? (IOException)x : new IOException(x.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean spoolResource0(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Method getResourceMethod = this.getGetResourceMethod();
        if (getResourceMethod == null) {
            return false;
        }
        String pi = request.getPathInfo();
        try {
            URL url = (URL)getResourceMethod.invoke(this.getResourceProvider(), pi);
            if (url == null) {
                return false;
            }
            URLConnection connection = url.openConnection();
            try (InputStream ins = connection.getInputStream();){
                int rd;
                if (ins == null) {
                    boolean bl = false;
                    return bl;
                }
                long lastModified = connection.getLastModified();
                if (lastModified > 0L) {
                    long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                    if (ifModifiedSince >= lastModified / 1000L * 1000L) {
                        response.setStatus(304);
                        boolean bl = true;
                        return bl;
                    }
                    response.setDateHeader("Last-Modified", lastModified);
                }
                response.setContentType(this.getServletContext().getMimeType(pi));
                response.setIntHeader("Content-Length", connection.getContentLength());
                ServletOutputStream out = response.getOutputStream();
                byte[] buf = new byte[2048];
                while ((rd = ins.read(buf)) >= 0) {
                    out.write(buf, 0, rd);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    protected PrintWriter startResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        VariableResolver resolver;
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        String title = this.getTitle();
        if (title.startsWith("%")) {
            title = "${" + title.substring(1) + "}";
        }
        if ((resolver = WebConsoleUtil.getVariableResolver(request)) instanceof DefaultVariableResolver) {
            DefaultVariableResolver r = (DefaultVariableResolver)resolver;
            r.put("head.title", title);
            r.put("head.label", this.getLabel());
            r.put("head.cssLinks", this.getCssLinks(appRoot));
            r.put("brand.name", brandingPlugin.getBrandName());
            r.put("brand.product.url", brandingPlugin.getProductURL());
            r.put("brand.product.name", brandingPlugin.getProductName());
            r.put("brand.product.img", AbstractWebConsolePlugin.toUrl(brandingPlugin.getProductImage(), appRoot));
            r.put("brand.favicon", AbstractWebConsolePlugin.toUrl(brandingPlugin.getFavIcon(), appRoot));
            r.put("brand.css", AbstractWebConsolePlugin.toUrl(brandingPlugin.getMainStyleSheet(), appRoot));
        }
        pw.println(this.getHeader());
        return pw;
    }

    protected void renderTopNavigation(HttpServletRequest request, PrintWriter pw) {
        String current = request.getPathInfo();
        int slash = current.indexOf("/", 1);
        if (slash < 0) {
            slash = current.length();
        }
        current = current.substring(1, slash);
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        Map menuMap = (Map)request.getAttribute("felix.webconsole.labelMap.categorized");
        this.renderMenu(menuMap, appRoot, pw);
        Map langMap = (Map)request.getAttribute("felix.webconsole.langMap");
        if (null != langMap && !langMap.isEmpty()) {
            String locale;
            Locale reqLocale = request.getLocale();
            String string = locale = null != reqLocale ? reqLocale.getLanguage() : Locale.getDefault().getLanguage();
            if (!langMap.containsKey(locale)) {
                locale = Locale.getDefault().getLanguage();
            }
            if (!langMap.containsKey(locale)) {
                locale = "en";
            }
            pw.println("<div id='langSelect'>");
            pw.println(" <span>");
            AbstractWebConsolePlugin.printLocaleElement(pw, appRoot, locale, langMap.get(locale));
            pw.println(" </span>");
            pw.println(" <span class='flags ui-helper-hidden'>");
            for (Object l : langMap.keySet()) {
                if (l.equals(locale)) continue;
                AbstractWebConsolePlugin.printLocaleElement(pw, appRoot, l, langMap.get(l));
            }
            pw.println(" </span>");
            pw.println("</div>");
        }
    }

    protected void renderMenu(Map menuMap, String appRoot, PrintWriter pw) {
        if (menuMap != null) {
            SortedMap categoryMap = this.sortMenuCategoryMap(menuMap, appRoot);
            pw.println("<ul id=\"navmenu\">");
            this.renderSubmenu(categoryMap, appRoot, pw, 0);
            pw.println("<li class=\"logoutButton navMenuItem-0\">");
            pw.println("<a href=\"" + appRoot + "/logout\">${logout}</a>");
            pw.println("</li>");
            pw.println("</ul>");
        }
    }

    private void renderMenu(Map menuMap, String appRoot, PrintWriter pw, int level) {
        pw.println("<ul class=\"navMenuLevel-" + level + "\">");
        this.renderSubmenu(menuMap, appRoot, pw, level);
        pw.println("</ul>");
    }

    private void renderSubmenu(Map menuMap, String appRoot, PrintWriter pw, int level) {
        String liStyleClass = " class=\"navMenuItem-" + level + "\"";
        for (String key : menuMap.keySet()) {
            MenuItem menuItem = (MenuItem)menuMap.get(key);
            pw.println("<li" + liStyleClass + ">" + menuItem.getLink());
            Map subMenu = menuItem.getSubMenu();
            if (subMenu != null) {
                this.renderMenu(subMenu, appRoot, pw, level + 1);
            }
            pw.println("</li>");
        }
    }

    private static final void printLocaleElement(PrintWriter pw, String appRoot, Object langCode, Object langName) {
        pw.print("  <img src='");
        pw.print(appRoot);
        pw.print("/res/flags/");
        pw.print(langCode);
        pw.print(".gif' alt='");
        pw.print(langCode);
        pw.print("' title='");
        pw.print(langName);
        pw.println("'/>");
    }

    protected void endResponse(PrintWriter pw) {
        pw.println(this.getFooter());
    }

    public static final String getParameter(HttpServletRequest request, String name) {
        return WebConsoleUtil.getParameter(request, name);
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String redirectUrl) throws IOException {
        WebConsoleUtil.sendRedirect(request, response, redirectUrl);
    }

    public static BrandingPlugin getBrandingPlugin() {
        return brandingPlugin;
    }

    public static final void setBrandingPlugin(BrandingPlugin brandingPlugin) {
        AbstractWebConsolePlugin.brandingPlugin = brandingPlugin == null ? DefaultBrandingPlugin.getInstance() : brandingPlugin;
    }

    public static final void setLogLevel(int logLevel) {
        AbstractWebConsolePlugin.logLevel = logLevel;
    }

    private final String getHeader() {
        if (HEADER == null) {
            HEADER = this.readTemplateFile(AbstractWebConsolePlugin.class, "/templates/main_header.html");
        }
        return HEADER;
    }

    private final String getFooter() {
        if (FOOTER == null) {
            FOOTER = this.readTemplateFile(AbstractWebConsolePlugin.class, "/templates/main_footer.html");
        }
        return FOOTER;
    }

    protected final String readTemplateFile(String templateFile) {
        return this.readTemplateFile(this.getClass(), templateFile);
    }

    /*
     * Exception decompiling
     */
    private final String readTemplateFile(Class clazz, String templateFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final String getCssLinks(String appRoot) {
        String[] cssRefs = this.getCssReferences();
        if (cssRefs == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < cssRefs.length; ++i) {
            buf.append("<link href='");
            buf.append(AbstractWebConsolePlugin.toUrl(cssRefs[i], appRoot));
            buf.append("' rel='stylesheet' type='text/css' />");
        }
        return buf.toString();
    }

    private static final String toUrl(String url, String appRoot) {
        if (url.startsWith("/")) {
            return appRoot + url;
        }
        return url;
    }

    private SortedMap sortMenuCategoryMap(Map map, String appRoot) {
        TreeMap<String, MenuItem> sortedMap = new TreeMap<String, MenuItem>(String.CASE_INSENSITIVE_ORDER);
        for (String key : map.keySet()) {
            if (key.startsWith("category.")) {
                SortedMap categoryMap = this.sortMenuCategoryMap((Map)map.get(key), appRoot);
                String title = key.substring(key.indexOf(46) + 1);
                if (sortedMap.containsKey(title)) {
                    ((MenuItem)sortedMap.get(title)).setSubMenu(categoryMap);
                    continue;
                }
                String link = "<a href=\"#\">" + title + "</a>";
                MenuItem menuItem = new MenuItem(link, categoryMap);
                sortedMap.put(title, menuItem);
                continue;
            }
            String title = (String)map.get(key);
            String link = "<a href=\"" + appRoot + "/" + key + "\">" + title + "</a>";
            if (sortedMap.containsKey(title)) {
                ((MenuItem)sortedMap.get(title)).setLink(link);
                continue;
            }
            MenuItem menuItem = new MenuItem(link);
            sortedMap.put(title, menuItem);
        }
        return sortedMap;
    }

    static {
        brandingPlugin = DefaultBrandingPlugin.getInstance();
    }

    @Deprecated(since="2021-04-30")
    private static class MenuItem {
        private String link;
        private Map subMenu;

        public MenuItem(String link) {
            this.link = link;
        }

        public MenuItem(String link, Map subMenu) {
            this.link = link;
            this.subMenu = subMenu;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public Map getSubMenu() {
            return this.subMenu;
        }

        public void setSubMenu(Map subMenu) {
            this.subMenu = subMenu;
        }
    }
}

